# Загрузка пакета в репозиторий

Для загрузки пакетов в репозитории используется программа `dupload`. Предполагается, что в конфигурационном файле этой программы содержатся параметры используемых репозиториев и получены соответствующие доступы (см. [Подготовка к работе с репозиториями](Repos.md)).

Чтобы загрузить пакет в репозиторий, нужно перейти в каталог, в котором находится собранный пакет, и выполнить команду:
```no-highlight
dupload --to repository_id package_fullName.changes 
```

- `repository_id` — название репозитория, параметры которого указаны в конфигурационном файле;
- `package_fullName.changes` — имя файла, содержащего описание пакета и изменений, которые были в нем произведены (см. [Создание, сборка и подписывание пакета](Building.md)).

> Пусть требуется загрузить пакет, изменения которого отражены в файле `mypackage-1.0.changes`, в репозиторий `yandex-hardy`. Для этого необходимо выполнить команду:
> 
> ```no-highlight
> dupload --to yandex-hardy mypackage-1.0.changes 
> ```

Более простым способом загрузки пакета является использование программы [debrelease](http://www.opennet.ru/man.shtml?topic=debrelease), запускаемой из каталога пакета:
```no-highlight
debrelease --to repository_id
```

Если ключ `--to` не используется, и `dupload` и `debrelease` будут пытаться загрузить пакет в репозиторий, заданный в конфигурационном файле программы `dupload` переменной `$default_host`. Так, для приведенного в разделе [Подготовка к работе с репозиториями](Repos.md) конфигурационного файла загрузка в репозиторий `verstka` может быть выполнена следующим образом:
```no-highlight
dupload package_fullName.changes
```

или

```no-highlight
debrelease
```

