#!/bin/bash

REPO_PATH='/repo'
CHMOD='/bin/chmod.bin'

CHMOD_FAIL_ERR=1

if [[ $PWD =~ "$REPO_PATH" ]]
then
  CHMOD_FAIL_ERR=0
fi

for arg in "$@"
do
  if [[ $arg =~ "$REPO_PATH" ]]
  then
    CHMOD_FAIL_ERR=0
  fi
done

$CHMOD $@
ERR=$?
if [[ $ERR -ne 0 && $CHMOD_FAIL_ERR -eq 0 ]]
then
  echo "chmod failed: you may ignore this warning"
  ERR=0
fi

exit $ERR

