#!/bin/bash

# pull config file
if [ -f /etc/pushrepo.conf ]; then
    . /etc/pushrepo.conf
else
    echo "Configuration file not found. Abort"
    exit 1;
fi

# check for root
if [[ ("$(id -u)" != "0") && ("$USER" != "loadbase") ]]; then
    echo -e "\n$(date +"%Y-%m-%d %H:%M:%S"): ERROR: Only root cat do that.\n"
    exit 1;
fi

# time fuction
logtime()
{
    date +%b" "%d" "%Y" "%T
}

REPOS=$(find $INCDIR -maxdepth 1 -mindepth 1 -type d | awk -F"/" '{ print $NF }')
TMPFILE=$(mktemp)

for repo in $REPOS; do
    for arch in $ARCHS; do

	# mini-dinstall incoming dir
    	MDINSTINC="/repo/$repo/mini-dinstall/incoming/"

	pushd $INCDIR/$repo/$arch > /dev/null 2>&1

	# get files from .changes
	CHFILES=$(find . -name "*.changes" | awk -F"/" '{ print $NF }')
	for chfile in $CHFILES; do
	    echo -e "$(logtime) INFO:  Found $chfile" >> $LOGFILE

	    # get md5sum file to check sums. We need to do it if some files
	    # did not upload entirely.
	    sed -e '1,/Files:/d;/^$/,$d;/BEGIN PGP SIGNATURE/,$d' $chfile | \
	        awk '{ print $1"  "$NF }' > $TMPFILE
	    md5sum -c $TMPFILE > /dev/null 2>&1
	    if [ $? -eq 0 ]; then
	    	echo -e "$(logtime) INFO:  MD5sums are valid for $chfile. Try to push" >> $LOGFILE

		# get trouble files (.dsc, .tar.gz, and .all.deb) for check in $MDINSTINC
		TROUBLEFILES="$MDINSTINC$chfile $(cat $TMPFILE | awk '{ print $NF }' | grep -v 'i386\.deb'| grep -v 'amd64\.deb')"
		TROUBLEFILES=$(echo $TROUBLEFILES | sed "s! ! -o -f $MDINSTINC!g")

		if [ -f $TROUBLEFILES ]; then
		    echo -e "$(logtime) ERROR: Found same files in mini-dinstall incoming dir. Try later" >> $LOGFILE
		else
#		    scp $chfile $(cat $TMPFILE | awk '{ print $NF }') root@scrap.yandex.ru:$MDINSTINC >> $LOGFILE
		    cp $chfile $(cat $TMPFILE | awk '{ print $NF }') $MDINSTINC
		    rm -f $chfile $(cat $TMPFILE | awk '{ print $NF }')
		    echo -e "$(logtime) INFO:  Move files from $chfile to $repo incoming" >> $LOGFILE
		fi
	    else
	    	echo -e "$(logtime) ERROR: Invalid MD5sums for $chfile. Try to wait" >> $LOGFILE
	    fi
	done
	popd > /dev/null 2>&1
    done
done

rm -f $TMPFILE
