#!/bin/bash

set +e

export CLEANER_DIR="cleaner"
echo "$(date +'%Y-%m-%d %H:%M:%S'): Starting repo-celaner"
if [[ ! -d "$CLEANER_DIR" ]]; then
  mkdir -p "$CLEANER_DIR"
fi
touch "$CLEANER_DIR/.sleep_needed"
for worker in /conf/repo-cleaner-*.sh; do
  echo "$(date +'%Y-%m-%d %H:%M:%S'): Spawning worker: $worker"
  zk-flock -x 10 -w 10 repo-cleaner $worker
  if [[ $? == 10 ]]; then
    echo "$(date +'%Y-%m-%d %H:%M:%S'): $worker is locked exiting..."
    rm -f "$CLEANER_DIR/.sleep_needed"
    break
  fi
done

if [[ -f "$CLEANER_DIR/.sleep_needed" ]]; then
  echo "$(date +'%Y-%m-%d %H:%M:%S'): additional sleep triggered... sleeping.. Zzz"
  zk-flock -x 10 -w 10 repo-cleaner 'sleep 1800'
  if [[ $? == 10 ]]; then
    echo "$(date +'%Y-%m-%d %H:%M:%S'): additional sleep failed, someone stole the lock..."
  fi
fi
echo "$(date +'%Y-%m-%d %H:%M:%S'): repo-cleaner: cleaning up"
rm -fv "$CLEANER_DIR/.sleep_needed"
unset CLEANER_DIR

sleep 3600

exit 0



