#!/bin/bash

set -x
sudo cp -Lvf /conf/sssd.conf sssd_real.conf
sudo chmod 600 sssd_real.conf
sudo chown root:root sssd_real.conf
sudo cp -av sssd_real.conf /etc/sssd/sssd.conf
sudo mkdir /opt/mirror
sudo chown loadbase:loadbase /opt/mirror
for i in $(ls ./ssh/); do sudo ln -sf $(readlink -f ./ssh/$i) /etc/ssh/$i; done
sudo sed -i '/secure_path/a Defaults    always_set_home' /etc/sudoers
sudo /usr/bin/gpg --import gnupg/secring.gpg
sudo bash -c 'echo "digest-algo SHA256" >> ~/.gnupg/gpg.conf'
sudo ln -sf `pwd`/motd /etc/update-motd.d/10-help-text
if [ -f /bin/chmod.bin ]; then
    echo 'chmod already pathched'
else
    echo 'patching chmod'
    sudo cp -L /conf/chmod.sh /bin/chmod.sh
    sudo chmod 755 /bin/chmod.sh
    sudo chown root:root /bin/chmod.sh
    sudo mv /bin/chmod /bin/chmod.bin
    sudo ln -sf /bin/chmod.sh /bin/chmod
fi
sudo chown root:root /
sudo rm /etc/cron.d/yandex-cauth
cat env_configs/cacus_template.yaml cacus_yaml/cacus_secret.yaml > cacus.yaml
chmod 660 cacus.yaml
sudo cp -Lv /conf/fix_permissions.sh /usr/bin
sudo chmod 755 /usr/bin/fix_permissions.sh
sudo chown root:root /usr/bin/fix_permissions.sh
sudo bash -c 'echo "*/1 * * * * root /usr/bin/fix_permissions.sh" >> /etc/crontab'
cp -L env_configs/driver.conf driver.conf
cp -L env_configs/distributed-flock.json distributed-flock.json
sudo cp -Lv env_configs/distributed-flock.json /etc/distributed-flock.json
sudo cp -Lvr ~/.gnupg /home/loadbase/
sudo chown -R loadbase:loadbase /home/loadbase/.gnupg
sudo cp -Lv .dupload.conf /home/loadbase/.dupload.conf
sudo chown loadbase:loadbase /home/loadbase/.dupload.conf
sudo mkdir /home/loadbase/mirroring/
sudo chown loadbase:loadbase /home/loadbase/mirroring/
sudo mkdir /home/loadbase/.ssh/
sudo cp -Lv id_rsa.loadbase/id_rsa.loadbase /home/loadbase/.ssh/id_rsa
sudo chown -R loadbase:loadbase /home/loadbase/.ssh
sudo chmod 700 /home/loadbase/.ssh
sudo chmod 600 /home/loadbase/.ssh/id_rsa
sudo touch /logs/current-dmove.log
sudo chown loadbase:root /logs/current-dmove.log
sudo chmod 664 /logs/current-dmove.log
sudo ln -fvs /logs/current-dmove.log /var/log/dmove.log
sudo bash -c 'echo "PubkeyAcceptedKeyTypes=+ssh-dss" >> /etc/ssh/sshd_config'
sudo bash -c 'echo "MaxSessions 30" >> /etc/ssh/sshd_config'
sudo bash -c 'echo "MaxStartups 33:1:200" >> /etc/ssh/sshd_config'
sudo cp -Lv /conf/check4changes /usr/bin/check4changes
sudo chown root:root /usr/bin/check4changes
sudo chmod 755 /usr/bin/check4changes
sudo mkdir -p /run/nginx/unistat
sudo chown loadbase:loadbase /run/nginx/unistat
sudo chmod 755 /run/nginx/unistat
