local log = ngx.log
local ERR = ngx.ERR
local WARN = ngx.WARN
local INFO = ngx.INFO

local function isempty(s)
	return s == nil or s == ""
end

function fetch_result(path_uri)
    local proxy_prefix = ngx.var.proxy_prefix or  '/proxy'
    local proxy_uri = proxy_prefix .. path_uri
    log(INFO, "Fetching URI ", proxy_uri)
    local response = ngx.location.capture(proxy_uri)
    if response.status == 404 then
        log(INFO, "Got 404 Not Found respose")
        return nil, "not found"
    elseif response.truncated then
        log(WARN, "Got truncated response")
        return nil, "truncated response"
    elseif response.status ~= 200 then
        log(WARN, "Failed fetching URI ", proxy_uri, ": ", response.status)
        return nil, "status code "..response.status
    end
    return response.body
end

local function usage()
	ngx.say("Usage:    ?pkg=<package name>[&ver=<package version>][&repo=<repository name>][&human=<True|False>][&strict=<True|False>][&withurls=<True|False>][&sources=<True|False>]")
	ngx.say("")
	ngx.say("pkg - search specific package")
	ngx.say("")
	ngx.say("Example:  ?pkg=nginx-common")
	ngx.say("          ?pkg=nginx-common&ver=1.6.3-1.yandex.9")
	ngx.say("          ?pkg=nginx-common&ver=1.6.3-1.yandex.9&repo=search-trusty")
end

local args = ngx.var["args"]
local package = ngx.var["arg_pkg"]
local version = ngx.var["arg_ver"]
local repo = ngx.var["arg_repo"]
local human = ngx.var["arg_human"]
local strict = ngx.var["arg_strict"]
local withurls = ngx.var["arg_withurls"]
local sources = ngx.var["arg_sources"]


if isempty(args) then
	usage()
	ngx.exit(ngx.HTTP_OK)
end

local find_url = "/api/v1/search?pkg=" .. package

if isempty(package) then
	ngx.status = ngx.HTTP_BAD_REQUEST
	usage()
	ngx.exit(ngx.HTTP_OK)
end

if not isempty(version) then
    find_url = find_url .. "&ver=" .. version
end
if not isempty(repo) then
    find_url = find_url .. "&repo=" .. repo
end
if not isempty(human) then
    find_url = find_url .. "&human=" .. human
end
if not isempty(strict) then
    find_url = find_url .. "&strict=" .. strict
end

if not isempty(withurls) then
    find_url = find_url .. "&withurls=" .. withurls
end

if not isempty(sources) then
    find_url = find_url .. "&sources=" .. sources
end

local find_results, err = fetch_result(find_url)
    if find_results == nil then
        if err == "not found" then
        	ngx.status = ngx.HTTP_NOT_FOUND
        	if isempty(repo) then
            	ngx.say("No such package on dist.yandex.ru")
        	else
            	ngx.say("No such package in repo " .. repo .. " on dist.yandex.ru")
            end
            ngx.exit(ngx.HTTP_OK)
        else
        	ngx.status = ngx.HTTP_BAD_REQUEST
        	ngx.say("Something go wrong. Error " .. err)
        	ngx.exit(ngx.HTTP_OK)
        end
    end

ngx.say(find_results)
ngx.exit(ngx.HTTP_OK)