package main

import (
	"context"
	"flag"
	"log"

	"a.yandex-team.ru/infra/dist/repo-daemon/internal/cache"
	"a.yandex-team.ru/infra/dist/repo-daemon/internal/cacus"
	"a.yandex-team.ru/infra/dist/repo-daemon/internal/mds"
	"a.yandex-team.ru/infra/dist/repo-daemon/internal/server"
	"a.yandex-team.ru/infra/dist/repo-daemon/pkg/logger"
)

func main() {
	cacheConfigPath := flag.String("cacheConfig", "cache.yaml", "Path to cache.yaml(must be readable by user)")
	cacusConfigPath := flag.String("cacusConfig", "cacus.yaml", "Path to cacus.yaml(must be readable by user)")
	debug := flag.Bool("debug", false, "Set logging level to debug")
	flag.Parse()
	cacheConfig, err := cache.LoadCacheYAML(*cacheConfigPath)
	if err != nil {
		log.Fatalf("cache.yaml: %s", err)
	}
	if *debug {
		cacheConfig.Log.Level = "debug"
	}
	err = logger.ConfigureLogging(cacheConfig.Log)
	if err != nil {
		log.Fatalf("Cannot initialize logging: %s", err)
	}
	cacusConfig, err := cacus.LoadCacusYAML(*cacusConfigPath)
	if err != nil {
		log.Fatalf("cacus.yaml: %s", err)
	}
	//Configure internals modules
	mdsClient := mds.NewMDSClient(cacusConfig.Storage)
	db := cacus.NewDBClient(cacusConfig.MetaDB.CacusDB, cacusConfig.MetaDB.ReposDB, cacusConfig.MetaDB.HistDB, cacusConfig.RepoDaemon)
	err = db.EstablishAllConnections(context.Background())
	if err != nil {
		log.Fatal(err)
	}
	c := cache.NewDistCache(cacheConfig, db, mdsClient)
	repoDaemon := server.NewRepoDaemon(cacusConfig.RepoDaemon, db, c)
	logger.Info("database connection established... starting server...")
	logger.Info(repoDaemon.StartServer(*debug))
}
