package cacus

import (
	"context"
	"time"

	"go.mongodb.org/mongo-driver/bson"
	"go.mongodb.org/mongo-driver/bson/primitive"
)

type PackageIndexHistoryEntry struct {
	ID          primitive.ObjectID `bson:"_id"`
	Env         string             `bson:"environment"`
	Arch        string             `bson:"architecture"`
	SHA256      string             `bson:"sha256"`
	StorageKey  string             `bson:"storage_key"`
	ValidBefore time.Time          `bson:"valid_before"`
	UpdatedAt   time.Time          `bson:"updated_at"`
}

func (db *DBClient) GetHistoryEntry(ctx context.Context, repo, env, arch, sha256 string) (*PackageIndexHistoryEntry, error) {
	if ctx == nil {
		ctx = context.Background()
	}
	c, err := db.GetHistoryClient(ctx)
	if err != nil {
		return nil, err
	}
	hdb := db.GetHistoryDB(c)
	col := hdb.Collection(repo)
	result := PackageIndexHistoryEntry{}
	err = col.FindOne(ctx, bson.M{"environment": env, "architecture": arch, "sha256": sha256}).Decode(&result)
	if err != nil {
		return nil, err
	}
	return &result, nil
}

func (db *DBClient) GetHistoryEntryWithTimeout(ctx context.Context, repo, env, arch, sha256 string, t time.Duration) (*PackageIndexHistoryEntry, error) {
	ctx, cancel := context.WithTimeout(ctx, t)
	defer cancel()
	return db.GetHistoryEntry(ctx, repo, env, arch, sha256)
}
