package server

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"

	"a.yandex-team.ru/infra/dist/repo-daemon/internal/cacus"
)

func TestByRepo(t *testing.T) {
	a := searchPackage{repo: "a"}
	b := searchPackage{repo: "b"}
	assert.Equal(t, true, byRepo(&a, &b, "+"))
	assert.Equal(t, false, byRepo(&a, &b, "-"))
}

func TestByUploadDate(t *testing.T) {
	aTime, _ := time.Parse(time.RFC3339, "2019-01-01T00:00:00Z")
	bTime, _ := time.Parse(time.RFC3339, "2019-01-02T00:00:00Z")
	a := searchPackage{pkg: cacus.RepoDocument{AuditMeta: []cacus.AuditMeta{{
		Timestamp: aTime,
		Event:     "upload",
		User:      "user-mock",
	}}}}
	b := searchPackage{pkg: cacus.RepoDocument{AuditMeta: []cacus.AuditMeta{{
		Timestamp: bTime,
		Event:     "upload",
		User:      "user-mock",
	}}}}
	assert.Equal(t, true, byUploadDate(&a, &b, "+"))
	assert.Equal(t, false, byUploadDate(&a, &b, "-"))
}

func TestBySource(t *testing.T) {
	a := searchPackage{pkg: cacus.RepoDocument{Source: "a"}}
	b := searchPackage{pkg: cacus.RepoDocument{Source: "b"}}
	assert.Equal(t, true, bySource(&a, &b, "+"))
	assert.Equal(t, false, bySource(&a, &b, "-"))
}

func TestByVersion(t *testing.T) {
	a := searchPackage{pkg: cacus.RepoDocument{Version: "1.0.0"}}
	b := searchPackage{pkg: cacus.RepoDocument{Version: "1.0.1"}}
	assert.Equal(t, true, byVersion(&a, &b, "+"))
	assert.Equal(t, false, byVersion(&a, &b, "-"))
}
