package server

import (
	"net/http"
	"strings"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/infra/dist/repo-daemon/internal/cache"
	"a.yandex-team.ru/infra/dist/repo-daemon/pkg/logger"
)

const (
	torrentFlag string = "rbtorrent"
)

type TorrentHandler struct {
	cache *cache.DistCache
}

func NewTorrentHandler(c *cache.DistCache) *TorrentHandler {
	return &TorrentHandler{cache: c}
}

func (h *TorrentHandler) Handler(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	err := r.ParseForm()
	if err != nil {
		w.WriteHeader(500)
		logger.Errorf("%s[%s]: cannot parse form", r.RequestURI, r.RemoteAddr)
		return
	}
	if r.Form.Get(torrentFlag) != "1" {
		w.WriteHeader(404)
		logger.Warningf("%s[%s]: TorrentHandler got request without torrent flag", r.RequestURI, r.RemoteAddr)
		return
	}
	storageKey := r.RequestURI[:strings.Index(r.RequestURI, "?")]
	torrentID, err := h.cache.GetTorrentID(ctx, chi.URLParam(r, "repo"), storageKey)
	if torrentID == "" {
		w.WriteHeader(404)
		logger.Errorf("%s[%s]: %s", r.RequestURI, r.RemoteAddr, err)
		return
	}
	w.Header().Set("X-Resource-Id", torrentID)
	w.WriteHeader(204)
}
