package server

import (
	"net/http"

	"a.yandex-team.ru/library/go/yandex/unistat"

	"a.yandex-team.ru/infra/dist/repo-daemon/pkg/logger"
)

func UnistatHandler(w http.ResponseWriter, r *http.Request) {
	bytes, err := unistat.MarshalJSON()
	if err != nil {
		logger.Errorf("%s[%s]: Cannot handle unistat request: %s", r.RequestURI, r.RemoteAddr, err)
		http.Error(w, err.Error(), http.StatusInternalServerError)
		return
	}
	w.Header().Set("Content-Type", "application/json; charset=utf-8")
	if n, err := w.Write(bytes); err != nil {
		logger.Errorf("%s[%s]: Request interrupted after %d bytes written: %s", r.RequestURI, r.RemoteAddr, n, err)
		return
	}
}
