package fileutil

import (
	"fmt"
	"os"
)

func FileExists(path string) bool {
	_, err := os.Stat(path)
	return err == nil
}

func ReadFile(path string) ([]byte, error) {
	var result []byte
	stat, err := os.Stat(path)
	if err != nil {
		return result, err
	}
	file, err := os.OpenFile(path, os.O_RDONLY, 0644)
	if err != nil {
		return result, err
	}
	result = make([]byte, stat.Size())
	n, err := file.Read(result)
	if n == 0 {
		return nil, fmt.Errorf("read empty file: %s, err: %s", path, err)
	}
	return result, nil
}
