package uautil

import (
	"errors"
	"net/http"
	"strconv"
	"strings"
)

var errAPTVersionParse = errors.New("apt version parse error")

func parseAPTVersion(v string) (uint64, error) {
	parts := strings.Split(v, "(")
	if len(parts) != 2 {
		return 0, errAPTVersionParse
	}
	version := uint64(0)
	versionString := parts[1][:len(parts[1])-1]
	versionParts := strings.SplitN(versionString, ".", 3)
	for vi, vp := range versionParts {
		if vi >= 2 {
			break
		}
		i, err := strconv.ParseUint(vp, 10, 64)
		if err != nil {
			continue
		}
		version += i << (16 * (3 - vi))
	}
	return version, nil
}

func GetAPTVersion(r *http.Request) (uint64, error) {
	ua := r.Header.Get("User-Agent")
	if ua == "" {
		return 0, errAPTVersionParse
	}
	if strings.HasPrefix(ua, "Debian APT-HTTP/1.3") {
		return parseAPTVersion(ua)
	} else {
		return 0, errAPTVersionParse
	}
}
