import click
from infra.dostavlyator.lib.misc import misc
from infra.dostavlyator.lib.activator import activator as activator_lib
from infra.dostavlyator.lib.debug import debug

log = misc.GetLogger('dostavlyator.activator')


@click.command()
@click.help_option("-h", "--help")
@click.option("--yt-cluster", default="markov", help="YT cluster")
@click.option("--yt-dir", required=True, help="Directory on YT cluster")
@click.option("--storage-dir", required=True, help="Storage directory path")
@click.option("--resource-set-dir", required=True, help="ResourceSet directory path")
@click.option("--output-dir", required=True, type=str, help="ResourceSet output directory path")
@click.option("--spec-file", required=True, type=str, help="Spec file")
@click.option("--state-file", required=False, type=str, help="State file", default=None)
@click.option("--notify-url", required=False, type=str, help="Url to notify user service", default=None)
@click.option("--once", is_flag=True, help="Calculate all and exit")
@click.option("--shadow-mode", is_flag=True, help="Don't store data to YT")
@click.option("--no-activate", is_flag=True, help="Don't create symlinks and don't call http notify-url")
@click.option("-v", "--verbose", is_flag=True, help="Enable verbose logging")
def main(
    yt_cluster,
    yt_dir,
    storage_dir,
    resource_set_dir,
    output_dir,
    spec_file,
    state_file,
    notify_url,
    once,
    shadow_mode,
    no_activate,
    verbose
):
    debug.init_debug_signals()
    misc.configure_logging(verbose)
    activator = activator_lib.Activator(
        yt_cluster=yt_cluster,
        yt_dir=yt_dir,
        storage_dir=storage_dir,
        resource_set_dir=resource_set_dir,
        output_dir=output_dir,
        spec_fname=spec_file,
        state_fname=state_file,
        notify_url=notify_url,
        once=once,
        shadow_mode=shadow_mode,
        no_activate=no_activate
    )
    activator.run()


if __name__ == '__main__':
    main()
