import os
import click
import yt.wrapper as yt

from infra.dostavlyator.lib.misc import misc
from infra.dostavlyator.lib.cli import cli as cli_lib
from infra.dostavlyator.lib.db import tables

log = misc.GetLogger("infra.dostavlyator.bin.cli")


@click.command()
@click.help_option("-h", "--help")
@click.option("--yt-cluster", default="markov", help="YT cluster")
@click.option("--yt-dir", required=True, help="Directory on YT cluster")
@click.option('--verbose', is_flag=True, help="Verbose logging")
@click.argument('args', nargs=-1)
def main(yt_cluster, yt_dir, verbose, args):
    misc.configure_logging(verbose)
    yt_client = yt.YtClient(yt_cluster, token=os.getenv("YT_TOKEN"), config={"backend": "rpc"})
    tables.CreateAllTables(yt_client, yt_dir)
    cli = cli_lib.CLI(yt_client=yt_client, yt_dir=yt_dir)
    if args:
        cli.execute(args)
    else:
        cli.interactive()


if __name__ == "__main__":
    main()
