import click
import humanfriendly
from infra.dostavlyator.lib.debug import debug
from infra.dostavlyator.lib.misc import misc
from infra.dostavlyator.lib.fetcher.fetcher import Fetcher


@click.command()
@click.help_option("-h", "--help")
@click.option("--yt-cluster", default="markov", help="YT cluster")
@click.option("--yt-dir", required=True, help="Directory on YT cluster")
@click.option("--storage-dir", required=True, help="Storage directory path")
@click.option("--size-limit", required=True, help="Total size limit for resources in storage directory, supports GB/MB/KB format")
@click.option("--network-limit", help="Network limit, supports GB/MB/KB format")
@click.option("--direct-io", is_flag=True, help="Use skynet.copier DirectIO feature")
@click.option("--verify-checksum", is_flag=True, help="Calculate and check MD5 summ after file fetch")
@click.option("--once", is_flag=True, help="Calculate all and exit")
@click.option("--shadow-mode", is_flag=True, help="Don't store data to YT")
@click.option("--verbose", is_flag=True, help="Enable verbose logging")
def main(yt_cluster, yt_dir, storage_dir, size_limit, network_limit, direct_io, verify_checksum, verbose, once, shadow_mode):
    debug.init_debug_signals()
    misc.configure_logging(verbose)
    # see https://humanfriendly.readthedocs.io/en/latest/api.html#humanfriendly.parse_size for supported formats
    size_limit = humanfriendly.parse_size(size_limit, binary=True)
    network_limit = humanfriendly.parse_size(network_limit, binary=True) if network_limit else None
    fetcher = Fetcher(yt_cluster, yt_dir, storage_dir, size_limit, network_limit, verify_checksum=verify_checksum, direct_io=direct_io, shadow_mode=shadow_mode, once=once)
    fetcher.run()


if __name__ == "__main__":
    main()
