import click
import os
import yt.wrapper as yt
from infra.dostavlyator.lib.db import tables
from infra.dostavlyator.lib.upravlyator import upravlyator as upravlyator_lib
from infra.dostavlyator.lib.misc import misc
from infra.dostavlyator.lib.debug import debug

log = misc.GetLogger('dostavlyator.upravlyator')


@click.command()
@click.help_option("-h", "--help")
@click.option("--abc-service", type=str, required=True, help="ABC service name")
@click.option("--yt-cluster", type=str, required=True, default="markov", help="YT cluster")
@click.option("--yt-dir", required=True, help="Directory on YT cluster")
@click.option("--verbose", is_flag=True, help="Enable verbose logging")
def main(abc_service, yt_cluster, yt_dir, verbose):
    debug.init_debug_signals()
    misc.register_signal_handlers()
    misc.configure_logging(verbose)
    yt_client = yt.YtClient(yt_cluster, token=os.getenv("YT_TOKEN"), config={"backend": "rpc"})
    tables.CreateAllTables(yt_client, base_path=yt_dir)

    upravlyator = upravlyator_lib.TUpravlyator(abc_service, yt_client, yt_dir)
    upravlyator.Run()


if __name__ == '__main__':
    main()
