from prompt_toolkit import PromptSession
from infra.dostavlyator.lib.db.db import DB
from infra.dostavlyator.lib.misc.misc import GetLogger
from infra.dostavlyator.lib.cli.completion import Completer
from infra.dostavlyator.lib.cli.executor import Executor

log = GetLogger("infra.dostavlyator.lib.cli.cli")


"""
HANDLERS = {
    TResourceCandidate.DESCRIPTOR.name: (LockResourceCandidateTable, LookupResourceCandidateTable, InsertResourceCandidateTable),
    TResource.DESCRIPTOR.name: (LockResourceTable, LookupResourceTable, InsertResourceTable),
    TResourceSet.DESCRIPTOR.name: (LockResourceSetTable, LookupResourceSetTable, InsertResourceSetTable),
}

    status = EStatus.Value(status)
    logger.info(f"Searching for \"{object_type}\" object with ID = \"{object_id}\"")
    lock_func, lookup_func, insert_func = HANDLERS[object_type]

    with yt_client.Transaction(type="tablet"):
        lock_func(yt_client, yt_dir, [{"Id": object_id}])
        objects = lookup_func(yt_client, yt_dir, [{"Id": object_id}])
        if not objects:
            raise Exception("Can't find object with such ID")
        _object = objects[0]
        logger.info(f"Found: {MessageToJson(_object)}")
        logger.info(f"Current object MANUAL status is: {EStatus.Name(_object.ManualStatus)}")
        if click.confirm(f"Are you sure you want to change object MANUAL status to {EStatus.Name(status)}?"):
            logger.info("Applying requested change ...")
            if status == EStatus.NONE:
                _object.ClearField("ManualStatus")
            else:
                _object.ManualStatus = status
            insert_func(yt_client, yt_dir, _object)
            logger.info("Success!")
        else:
            logger.info("Exiting without any changes!")
"""


class CLI:
    def __init__(self, yt_client, yt_dir):
        self.yt_client = yt_client
        self.yt_dir = yt_dir
        self.db = DB(yt_client=self.yt_client, base_path=self.yt_dir)
        print("Loading...")
        try:
            self.db.ReadTables()
        except Exception as e:
            log.error(e)

    def print(self, data):
        if isinstance(data, tuple):
            fields, rows = data
            for x in rows:
                print(x)
        elif isinstance(data, bool):
            print("OK" if data else 'FAIL')

    def execute(self, args):
        executor = Executor(self.db)
        result = executor.execute(list(args))
        self.print(result)

    def interactive(self):
        completer = Completer(self.db)
        session = PromptSession()
        print("Type 'exit' to exit. <Tab> to hints.")
        while True:
            text = session.prompt('> ', completer=completer, complete_while_typing=True)
            if not text:
                continue
            if text == "exit":
                break
            try:
                self.execute(text.split(' '))
            except Exception as e:
                log.error(e)
