from hashlib import sha256
from infra.dostavlyator.proto.main_pb2 import (
    EStatus,
    TResourceSpec,
    TResourceCandidate,
    TResource,
    TResourceSetSpec,
    TResourceSet,
)


def CalculateId(msg):
    origin_id = msg.Id
    origin_version = getattr(msg, 'Version', None)
    origin_manual_status = getattr(msg, 'ManualStatus', None)
    origin_validation_status = getattr(msg, 'ValidationStatus', None)
    origin_validator = getattr(msg, 'Validator', None)
    origin_prefetch = getattr(msg, 'Prefetch', None)
    msg.Id = ''
    if origin_version is not None:
        msg.Version = 0
    if origin_manual_status is not None:
        msg.ClearField('ManualStatus')
    if origin_validation_status is not None:
        msg.ClearField('ValidationStatus')
    if origin_validator is not None:
        msg.ClearField('Validator')
    if origin_prefetch is not None:
        msg.ClearField('Prefetch')
    data = msg.SerializeToString()
    digest = sha256(data).hexdigest()
    msg.Id = origin_id
    if origin_version is not None:
        msg.Version = origin_version
    if origin_manual_status is not None:
        msg.ManualStatus = origin_manual_status
    if origin_validation_status is not None:
        msg.ValidationStatus = origin_validation_status
    if origin_validator is not None:
        msg.Validator = origin_validator
    if origin_prefetch is not None:
        msg.Prefetch = origin_prefetch
    return digest


def ClassInit(self, *args, **kwargs):
    self._orig__init__(*args, **kwargs)
    if args or kwargs:
        if not self.Id:
            self.SetId()


def ClassCalculateId(self):
    return CalculateId(self)


def ClassSetId(self, id=None):
    self.Id = CalculateId(self) if id is None else id


def ClassIsValidId(self):
    return self.Id == CalculateId(self)


def ClassHash(self):
    return hash(self.Id)


def PatchClass(c):
    c._orig__init__ = c.__init__
    c.__init__ = ClassInit
    c.__hash__ = ClassHash
    c.CaldulateId = ClassCalculateId
    c.SetId = ClassSetId
    c.IsValidId = ClassIsValidId


def ValidationStatusName(valudation_status):
    return EStatus.Name(valudation_status)


PatchClass(TResourceSpec)
PatchClass(TResourceCandidate)
PatchClass(TResource)
PatchClass(TResourceSetSpec)
PatchClass(TResourceSet)
