from infra.dostavlyator.lib.db.tables import (
    LockControlFlagsNode,
    ReadControlFlagsNode,
    InsertControlFlagsNode,
    UnLockControlFlagsNode,
)


def freeze(yt_client, base_path):
    with yt_client.Transaction(type="master"):
        LockControlFlagsNode(yt_client, base_path)
        flags = ReadControlFlagsNode(yt_client, base_path)
        flags.freeze = True
        InsertControlFlagsNode(yt_client, base_path, flags)
        UnLockControlFlagsNode(yt_client, base_path)


def unfreeze(yt_client, base_path):
    with yt_client.Transaction(type="master"):
        LockControlFlagsNode(yt_client, base_path)
        flags = ReadControlFlagsNode(yt_client, base_path)
        flags.freeze = False
        InsertControlFlagsNode(yt_client, base_path, flags)
        UnLockControlFlagsNode(yt_client, base_path)


def wipe_db(yt_client, base_path):
    with yt_client.Transaction(type="master"):
        LockControlFlagsNode(yt_client, base_path)
        flags = ReadControlFlagsNode(yt_client, base_path)
        flags.wipe = True
        InsertControlFlagsNode(yt_client, base_path, flags)
        UnLockControlFlagsNode(yt_client, base_path)


def unwipe_db(yt_client, base_path):
    with yt_client.Transaction(type="master"):
        LockControlFlagsNode(yt_client, base_path)
        flags = ReadControlFlagsNode(yt_client, base_path)
        flags.wipe = False
        InsertControlFlagsNode(yt_client, base_path, flags)
        UnLockControlFlagsNode(yt_client, base_path)
