from infra.dostavlyator.lib.data.spec import (
    TResourceSpec,
    TResourceSetSpec,
)
from infra.dostavlyator.proto.main_pb2 import (
    TResourceSetDownloadSpec,
    TDownloadSpec,
    TBoxRequestedSpec,
)
from infra.dostavlyator.lib.db.tables import TBoxRequestedTable
from infra.dostavlyator.lib.misc.misc import get_instance_details, mkjson, GetLogger
import traceback
import logging
import signal
import code

log = GetLogger('dostavlyator.lib.upravlyator')


def init_debug_signals():
    def usr1_handler(sig, frame):
        d={'_frame': frame}
        d.update(frame.f_globals)
        d.update(frame.f_locals)
        i = code.InteractiveConsole(d)
        message = "Signal received : entering python shell.\nTraceback:\n"
        message += ''.join(traceback.format_stack(frame))
        i.interact(message)

    def usr2_handler(sig, frame):
        traceback.print_stack(f=frame)
        logging.getLogger("Yt").setLevel(logging.DEBUG)

    signal.signal(signal.SIGUSR1, usr1_handler)
    signal.signal(signal.SIGUSR2, usr2_handler)


def GetDebugTBoxRequestedSpec():
    # TResourceSpec(Path='0147867084.cache.amacs', Uri='bstr://locke.yt.yandex-team.ru//home/adfox/bridge/deploy-production/bstr/0147867084.cache.amacs', CheckIntervalSec=60, RecheckIntervalSec=0),
    resource_1 = [
        TResourceSpec(
            Path='*',
            Uri='sbr://',
            UriOpt=mkjson(type="BRUTAL_TSAR_MODEL", owner='brutalman', state='READY', attrs={"released": "stable"}),
            CheckIntervalSec=9 * 24 * 60 * 60,
            RecheckIntervalSec=15,
        ),
    ]
    resource_2 = [
        TResourceSpec(
            Path='*',
            Uri='sbr://',
            UriOpt=mkjson(
                type="BRUTAL_RSYA_CTR_TSAR_MODEL", owner='brutalman', state='READY', attrs={"released": "stable"}
            ),
            CheckIntervalSec=12 * 60 * 60,
            RecheckIntervalSec=15,
        ),
    ]
    resource_3 = [
        TResourceSpec(
            Path='*',
            Uri='sbr://',
            UriOpt=mkjson(
                type="ML_STORAGE_DUMP",
                owner='ADS-ML-STORAGE',
                state='READY',
                attrs={
                    "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                    "dump_key": "user_page",
                    "environment_type": "production",
                },
            ),
            CheckIntervalSec=4 * 60 * 60,
            RecheckIntervalSec=0,
        ),
        TResourceSpec(
            Path='*',
            Uri='sbr://',
            UriOpt=mkjson(
                type="ML_STORAGE_DUMP",
                owner='ADS-ML-STORAGE',
                state='READY',
                attrs={
                    "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                    "dump_key": "user_profile",
                    "environment_type": "production",
                },
            ),
            CheckIntervalSec=4 * 60 * 60,
            RecheckIntervalSec=0,
        ),
        TResourceSpec(
            Path='*',
            Uri='sbr://',
            UriOpt=mkjson(
                type="ML_STORAGE_DUMP",
                owner='ADS-ML-STORAGE',
                state='READY',
                attrs={
                    "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                    "dump_key": "user_top",
                    "environment_type": "production",
                },
            ),
            CheckIntervalSec=4 * 60 * 60,
            RecheckIntervalSec=0,
        ),
    ]
    resource_set = [
        TResourceSetSpec(
            Path='brutal_incremental_dssm',
            Resource=[res.Id for res in resource_1],
            GenerationPeriodSec=60,
            ValidateMax=0.1,
            ValidateMin=3,
            RollingDurationSec=10,
            RollbackVersions=1,
            RollbackFactor=0.99,
        ),
        TResourceSetSpec(
            Path='brutal_rsya_ctr_tsar_model',
            Resource=[res.Id for res in resource_2],
            GenerationPeriodSec=60,
            ValidateMax=0.1,
            ValidateMin=3,
            RollingDurationSec=10,
            RollbackVersions=1,
            RollbackFactor=0.99,
        ),
        TResourceSetSpec(
            Path='pytorch_bc_rsya_torchv2_hitsplit',
            Resource=[res.Id for res in resource_3],
            GenerationPeriodSec=60,
            ValidateMax=0.1,
            ValidateMin=3,
            RollingDurationSec=10,
            RollbackVersions=1,
            RollbackFactor=0.99,
        ),
    ]
    download_resource_set_spec = [
        TResourceSetDownloadSpec(ResourceSetId=res_set.Id, Priority=1.0) for res_set in resource_set
    ]
    download_spec = TDownloadSpec(ResourceSetDownloadSpec=download_resource_set_spec)
    request_spec = TBoxRequestedSpec(
        Resource=resource_1 + resource_2 + resource_3, ResourceSet=resource_set, DownloadSpec=download_spec
    )
    return request_spec


def GetDebugTBoxRequestedTable():
    instance_details = get_instance_details()
    request_spec = GetDebugTBoxRequestedSpec()
    box_request = TBoxRequestedTable(Spec=request_spec, **instance_details)
    return box_request


def check_box_requested_consistency(*, box_requested_proto, box_requested, db):
    proto_resource_set_spec_ids = set(resource_set_spec_proto.Id for resource_set_spec_proto in box_requested_proto.Spec.ResourceSet)
    if not proto_resource_set_spec_ids.issubset(db.resource_set_spec.keys()):
        log.error("requested resource_set_spec not in DB")
    if proto_resource_set_spec_ids != set(resource_set_spec.Id for resource_set_spec in box_requested.resource_set_spec):
        log.error("requested resource_set_spec not in linked resource_set_spec")
    for resource_set_spec in box_requested.resource_set_spec:
        if box_requested not in resource_set_spec.box_requested:
            log.error("box_requested not in resource_set_spec.box_requested")
