import logging
import pathlib

from infra.dostavlyator.lib.misc import misc


logger = logging.getLogger(__name__)


def run_cleanup(storage_dir: pathlib.Path, whitelisted_paths: set, broken_paths: set, size_limit: int):
    logger.info("Executing cleanup, removing resource candidates:")
    current_storage_size = sum(misc.safe_stat(path)["size"] for path in storage_dir.iterdir())
    outdated_paths = [path for path in storage_dir.iterdir() if path not in whitelisted_paths]
    outdated_paths_stat = {path: misc.safe_stat(path) for path in outdated_paths}
    logger.debug(f'outdated_paths_stat={outdated_paths_stat}')
    logger.debug(f'current_storage_size={current_storage_size}')
    outdated_paths_sorted = sorted(outdated_paths, key=lambda path: outdated_paths_stat[path]["mtime"])
    for p in outdated_paths_sorted:
        if current_storage_size < size_limit:
            return
        logger.info(f"- {p}")
        if misc.safe_remove(p):
            current_storage_size -= outdated_paths_stat[p]["size"]
    logger.info(broken_paths)
    for p in broken_paths:
        if current_storage_size < size_limit:
            return
        logger.info(f"- {p}")
        if misc.safe_remove(p):
            current_storage_size -= outdated_paths_stat[p]["size"]
    if current_storage_size > size_limit:
        raise Exception("Cleanup successfully executed, but storage size still exceeds size limit!")
