import yt.wrapper as yt
from infra.dostavlyator.lib.misc.misc import uriparse
from infra.dostavlyator.lib.data import spec
from infra.dostavlyator.proto import main_pb2
from search.plutonium.deploy.proto import sources_pb2


scheme = ['bstr']


def GetResourceCandidate(gather_uri, gather_uri_opt) -> list:
    u = uriparse(gather_uri)
    yt_client = yt.YtClient(u.authority, config=yt.config.config)
    torrent = yt_client.get(u.path + '/@_bstr_info/torrent')
    return [
        spec.TResourceCandidate(
            Id=torrent,
            Source=sources_pb2.TSource(Skynet=sources_pb2.TSkynetSource(Url=torrent)),
            SourceStatus=main_pb2.EStatus.VALID,
        )
    ]


def CheckResourceStatus(check_status_uri, check_status_uri_opt):
    pass
