from os import getenv
from time import time
from dateutil.parser import isoparse
from json import loads as json_loads, dumps as json_dumps
from infra.dostavlyator.lib.misc.misc import uriparse, GetLogger
from infra.dostavlyator.lib.data import spec
from infra.dostavlyator.proto import main_pb2
from search.plutonium.deploy.proto import sources_pb2

import sandbox.projects.ads.emily.storage.client.binary as mls_binary_client

log = GetLogger('dostavlyator.lib.sources.ml')
scheme = ['ml']

mls_client = None
mls_client_timestamp = 0


def get_client():
    global mls_client
    global mls_client_timestamp
    if (time() - mls_client_timestamp) > 3600:
        mls_client = mls_binary_client.MlStorageBinaryClient(token=getenv("ML_STORAGE_TOKEN"))
        mls_client_timestamp = time()
    return mls_client


def GetResourceCandidate(gather_uri, gather_uri_opt) -> list:
    uri = uriparse(gather_uri)
    if uri.authority:
        log.error('found not empty uri: "%s", this option is deprecated', gather_uri)
    opt = json_loads(gather_uri_opt)
    part = opt['part']
    del opt['part']
    if 'prod' not in opt:
        opt['prod'] = True
    if 'latest' not in opt and 'version' not in opt:
        opt['latest'] = True

    client = get_client()
    info = client.info(**opt)
    ctime = int(isoparse(info['created_time']).timestamp())
    skynet_id = info['parts'][part]['skynet_id']
    resource_candidate_id = 'ml_' + skynet_id.split(':')[1]
    check_status_uri = 'ml://'
    if 'latest' in opt:
        del opt['latest']
    opt['part'] = part
    opt['version'] = info['version']
    check_status_uri_opt = json_dumps(opt)
    return [
        spec.TResourceCandidate(
            Id=resource_candidate_id,
            Source=sources_pb2.TSource(Skynet=sources_pb2.TSkynetSource(Url=skynet_id)),
            CheckStatusUri=check_status_uri,
            CheckStatusUriOpt=check_status_uri_opt,
            SourceStatus=main_pb2.EStatus.VALID,
            SourceCreationTime=ctime,
        )
    ]


def CheckResourceStatus(check_status_uri, check_status_uri_opt):
    pass
