from infra.dostavlyator.lib.misc.misc import uriparse
from importlib import import_module

_source_types = {}


def RegisterSourceTypeModule(module_path):
    m = import_module(module_path)
    for s in m.scheme:
        _source_types[s] = m


def GetModule(uri):
    scheme = uriparse(uri).scheme
    assert scheme
    return _source_types[scheme]


def GetResourceCandidate(gather_uri, gather_uri_opt) -> list:
    return GetModule(gather_uri).GetResourceCandidate(gather_uri=gather_uri, gather_uri_opt=gather_uri_opt)


def CheckResourceStatus(check_status_uri, check_status_uri_opt):
    return GetModule(check_status_uri).CheckResourceStatus(
        check_status_uri=check_status_uri, check_status_uri_opt=check_status_uri_opt
    )


RegisterSourceTypeModule('infra.dostavlyator.lib.upravlyator.sources.bstr')
RegisterSourceTypeModule('infra.dostavlyator.lib.upravlyator.sources.sbr')
RegisterSourceTypeModule('infra.dostavlyator.lib.upravlyator.sources.ml')
