from dateutil.parser import isoparse
from json import loads as json_loads
from sandbox.common.rest import Client as SandboxClient
from infra.dostavlyator.lib.misc.misc import uriparse, GetLogger
from infra.dostavlyator.lib.data import spec
from infra.dostavlyator.proto import main_pb2
from search.plutonium.deploy.proto import sources_pb2

log = GetLogger('dostavlyator.lib.sources.sbr')
scheme = ['sbr']


def ReleasedToStatus(released):
    if released == 'stable':
        return main_pb2.EStatus.VALID
    if released == 'testing' or released == 'prestable':
        return main_pb2.EStatus.TESTING
    return main_pb2.EStatus.BAD


def GetResourceCandidate(gather_uri, gather_uri_opt, limit=10) -> list:
    opt = json_loads(gather_uri_opt)
    if 'limit' not in opt:
        opt['limit'] = limit
    sandbox = SandboxClient()
    answer = sandbox.resource.read(**opt)
    resources = answer['items']
    result = list()
    for resource in resources:
        resource_candidate_id = f'sbr_{resource["id"]}'
        released = resource['attributes']['released'] if 'released' in resource['attributes'] else None
        check_status_uri = resource_candidate_id if released else None
        ctime = int(isoparse(resource['time']['created']).timestamp())
        resource_candidate = spec.TResourceCandidate(
            Id=resource_candidate_id,
            Source=sources_pb2.TSource(Skynet=sources_pb2.TSkynetSource(Url=resource['skynet_id'])),
            CheckStatusUri=check_status_uri,
            SourceStatus=ReleasedToStatus(released) if released else main_pb2.EStatus.VALID,
            SourceCreationTime=ctime,
        )
        result.append(resource_candidate)
    return sorted(result, key=lambda x: x.SourceCreationTime, reverse=False)


def CheckResourceStatus(check_status_uri, check_status_uri_opt):
    u = uriparse(check_status_uri)
    resource_id = u.authority
    sandbox = SandboxClient()
    answer = sandbox.resource[resource_id].attribute['released'].read()
    return ReleasedToStatus(answer)
