import logging
import time
import random
from threading import Thread
from datetime import datetime

import numpy
import requests


logging.captureWarnings(True)


# URL = 'https://pre-ui-proxy.deploy.yandex-team.ru/api/logs/SearchLogEntries/'
URL = 'http://[::]:8080/api/logs/SearchLogEntries/'
# URL = 'https://pre-ui-proxy.deploy.yandex-team.ru/api/logs/DummyAction/'


STAGES = (
    # ('push-agent-proxy-stage', (datetime(2019, 7, 2),
                                # datetime(2019, 7, 7))),
    ('dev-rsc-sas-test', (datetime(2019, 7, 9),
                          datetime(2019, 7, 9, 23, 59, 59))),
)

ORDERS = ('ASC', 'DESC')

LOG_LEVES = ('INFO', 'DEBUG', 'WARNING', 'ERROR')


def random_dt(start, end):
    start = int(start.strftime("%s"))
    end = int(end.strftime("%s"))
    ts = random.randrange(start, end)
    dt = datetime.fromtimestamp(ts)
    h = random.randrange(12, 20)
    return dt.replace(hour=h)


def stress_test(num_threads, num_requests):
    session = requests.session()
    jobs = [i for i in range(num_requests)]

    def worker(results):
        while True:
            try:
                jobs.pop()
            except IndexError:
                break
            stage_id, rng = random.choice(STAGES)
            start, end = rng
            from_ts = random_dt(start, end).isoformat() + 'Z'
            order = random.choice(ORDERS)
            log_level = random.choice(LOG_LEVES)

            d = {
                'stage_id': stage_id,
                'log_level': 'INFO',  # log_level,
                'from_timestamp': from_ts,
                'order': order,
                'limit': 150
            }
            t1 = time.time()
            r = session.post(url=URL, json=d, verify=False)
            code = r.status_code
            len_content = len(r.content)
            t2 = time.time()
            print(code, len_content, t2 - t1)
            results.append((r.status_code, len(r.content), t2 - t1))

    results = []
    if num_threads > 1:
        threads = [Thread(target=worker, args=(results,))
                   for _ in range(num_threads)]
        for thread in threads:
            thread.start()
        for thread in threads:
            thread.join()
    else:
        worker(results)
    return results


if __name__ == '__main__':
    NUM_THREADS = 100
    NUM_REQUESTS = 1000

    start_time = time.time()
    results = stress_test(NUM_THREADS, NUM_REQUESTS)
    end_time = time.time()

    fail_count = 0
    sizes = []
    times = []
    try:
        for r in results:
            status, size, t = r
            if status != 200:
                fail_count += 1
            sizes.append(size)
            times.append(t)
    finally:
        print('requests {}/{}; threads {}; tottime {}; reqtime_95 {}; reqtime 50 {}; payload_95 {}'.format(
            NUM_REQUESTS,
            fail_count,
            NUM_THREADS,
            round(end_time - start_time, 2),
            round(numpy.percentile(times, 95), 2),
            round(numpy.percentile(times, 50), 2),
            numpy.percentile(sizes, 96)
        ))
