from __future__ import unicode_literals
import sys

from library.python.vault_client import errors as yav_errors

from infra.swatlib.rpc import exceptions


DEFAULT_YAV_ERROR_MESSAGE = "Unknown YAV error occurred"


def translate_yav_error(e):
    code = e.kwargs.get('code')
    if e.kwargs.get('message'):
        msg = 'YAV error occurred: {}'.format(e.kwargs['message'])
    else:
        msg = DEFAULT_YAV_ERROR_MESSAGE

    if code == 'access_error':
        return exceptions.ForbiddenError, msg
    if code in ('invalid_uuid_value', 'invalid_uuid_prefix', 'validation_error'):
        return exceptions.BadRequestError, msg
    return exceptions.InternalError, msg


def translate_app_errors(f):
    """
    Handles application errors (like requests exception, ISS exception, etc) and translates them
    into RPC errors with proper error codes and nice description for user.

    :param f: function to wrap
    """

    def wrapper(*args, **kwargs):
        try:
            return f(*args, **kwargs)
        except yav_errors.ClientError as e:
            e, exc_args = translate_yav_error(e)
        # Grab traceback and raise new exception with it
        # So that we don't loose exception context
        traceback = sys.exc_info()[2]
        if not isinstance(exc_args, tuple):
            exc_args = (exc_args,)
        raise e, exc_args, traceback

    return wrapper
