from flask import g

from infra.dproxy.proto.dproxy_pb2 import GetQloudEnvMigrationReadinessRequest
from infra.dproxy.proto.dproxy_pb2 import GetQloudEnvMigrationReadinessResponse
from infra.dproxy.src.lib.rpc import blueprint

yd_migrate_blueprint = blueprint.HttpRpcBlueprint('rpc.migrate_service',
                                                  __name__,
                                                  '/api/migrate',
                                                  serialize_resp_threads_count=10)


def is_ready_for_migrate(req, qloud_ready_list, platform_ready_list):
    if req.section == GetQloudEnvMigrationReadinessRequest.QloudSection.QLOUD:
        ready_list = qloud_ready_list
    else:
        ready_list = platform_ready_list

    resp = GetQloudEnvMigrationReadinessResponse()
    resp.migration_state = GetQloudEnvMigrationReadinessResponse.ReadinessState.READY if (req.environment_id in ready_list) \
                           else GetQloudEnvMigrationReadinessResponse.ReadinessState.NOT_READY

    return resp


@yd_migrate_blueprint.method('GetQloudEnvMigrationReadiness',
                             request_type=GetQloudEnvMigrationReadinessRequest,
                             response_type=GetQloudEnvMigrationReadinessResponse,
                             need_authentication=True)
def blueprint_is_ready_for_migrate(req, auth_subject):
    return is_ready_for_migrate(req, g.ctx.qloud_ready_list, g.ctx.platform_ready_list)
