import calendar
import datetime

TIMESTAMP_FORMAT = "%Y-%m-%dT%H:%M:%S.%fZ"


def dt_to_str(dt):
    return dt.strftime(TIMESTAMP_FORMAT)


def dt_to_microseconds(dt):
    if isinstance(dt, datetime.datetime):
        delta = dt - datetime.datetime(1970, 1, 1)
        return (delta.days * 24 * 60 * 60 + delta.seconds) * 1000000 + delta.microseconds
    else:
        return dt.ToMicroseconds()


def microseconds_to_dt(microseconds):
    return datetime.datetime(1970, 1, 1) + datetime.timedelta(microseconds=microseconds)


def datetime_from_ts_us(microseconds):
    return datetime.datetime.utcfromtimestamp(microseconds // 10 ** 6).replace(microsecond=microseconds % 10 ** 6)


def datetime_to_ts_us(dt):
    return calendar.timegm(dt.timetuple()) * 10 ** 6 + dt.microsecond


def start_of_day(dt):
    return dt.replace(hour=0, minute=0, second=0, microsecond=0)
