/*
    Hello World - example of Yandex.Drug service
    one replica_set with stateless http server

    service.jsonnet should generate service recipe as json
    jsonnet is a data templating language - an extension of JSON
    learn more at https://jsonnet.org
*/

// import Yandex.Drug jsonnet modules
// every module contains helper-functions for generating Drug objects (replica_sets, endpoint_sets, etc.)
local data_model = import 'lib/data_model.jsonnet.TEMPLATE';  //   disk and network
local pod_agent = import 'lib/pod_agent.jsonnet.TEMPLATE';  //     resources, boxes, workloads
local recipe = import 'lib/recipe.jsonnet.TEMPLATE';  //           recipe templates: uniform, shards
local replica_set = import 'lib/replica_set.jsonnet.TEMPLATE';  // replica_set and its deployment strategies

// return service recipe
// json output is canonized at exectest - see ya.make and canondata nearby
recipe.uniform_service(  //                                           creates one replica_set at each given cluster
    id='hello_world',
    replica_set_spec=replica_set.simple(
        account_id='abc:service:3494',  //                            resources will be allocated from account's quota
        replica_count=3,
        pod_agent_spec=pod_agent.upper_layer(  //                     one box with ubuntu xenial and user's upper layer (any .tar.gz)
            layer_sb_id=755375039,  //                                simple_http_server.tar.gz with executable
            start_cmd="/simple_http_server 8080 'hello yanddmi'",  // port and static message for http server
        ),
        resource_request={ vcpu_guarantee: 500, memory_guarantee: 1 << 28 },
        disk_volume_request=data_model.disk_volume_capacity(1 << 31),
        ip6_address_request=data_model.ip6_address_network_id('_GENCFG_SEARCHPRODNETS_ROOT_')
    ),
    clusters=['SAS', 'MAN', 'VLA']
)
