local pod_agent = import 'lib/pod_agent.jsonnet.TEMPLATE';
local locals = import 'locals.jsonnet';

{
    layers: {
        xenial: pod_agent.layer_ubuntu_xenial,
        cosmic: pod_agent.layer_ubuntu_cosmic,
        generate: pod_agent.layer_from_sandbox(locals.generate),
        serve: pod_agent.layer_from_sandbox(locals.serve),
    },
    staticResources: {
        generate_cfg: pod_agent.resource_from_sandbox(locals.generate_cfg),
        serve_cfg: pod_agent.resource_from_sandbox(locals.serve_cfg),
    },
    volumes: {
        db: {
            id: 'db',
        },
    },
    boxes: {
        local shared_db_mount_point(mode) = {
            volume_ref: $.volumes.db.id,
            mount_point: '/db',
            mode: mode,
        },
        generate: {
            id: 'generate',
            rootfs: {
                layer_refs: [$.layers.xenial.id, $.layers.generate.id],
            },
            volumes: [shared_db_mount_point('read_write')],
            static_resources: [{ resource_ref: $.staticResources.generate_cfg.id, mount_point: '/binaries/generate' }],
        },
        serve: {
            id: 'serve',
            rootfs: {
                layer_refs: [$.layers.cosmic.id, $.layers.serve.id],
            },
            volumes: [shared_db_mount_point('read_only')],
            static_resources: [{ resource_ref: $.staticResources.serve_cfg.id, mount_point: '/binaries/serve' }],
        },
    },
    workloads: {
        generate: {
            id: 'generate',
            start: {
                command_line: '/binaries/generate /binaries/generate.cfg',
                compute_resources: { vcpu_guarantee: 10000, memory_guarantee: 16 * (1 << 30) },
            },
            stop_policy: {
                container: {
                    command_line: '/binaries/generate stop',
                },
                max_tries: 3,
            },
            readiness_check: {
                container: {
                    command_line: '/binaries/generate status',
                },
            },
            box_ref: $.boxes.generate.id,
        },
        serve: {
            id: 'serve',
            start: {
                command_line: '/binaries/serve /binaries/serve.cfg',
                compute_resources: { vcpu_guarantee: 20000, memory_guarantee: locals.index_mem },
            },
            stop_policy: {
                container: {
                    command_line: '/binaries/serve stop',
                },
                max_tries: 3,
            },
            readiness_check: {
                container: {
                    command_line: '/binaries/serve status',
                },
            },
            box_ref: $.boxes.serve.id,
        },
    },
}
