local data_model = import 'lib/data_model.jsonnet.TEMPLATE';
local recipe = import 'lib/recipe.jsonnet.TEMPLATE';
local replica_set = import 'lib/replica_set.jsonnet.TEMPLATE';

local components = import 'components.jsonnet';
local locals = import 'locals.jsonnet';

// prepare replica_set spec
local replica_set_spec = replica_set.simple(
    account_id='abc:service:1234',
    replica_count=locals.replica_count,
    pod_agent_spec={
        resources: {
            static_resources: [components.staticResources.generate_cfg, components.staticResources.serve_cfg],
            layers: [components.layers.xenial, components.layers.cosmic, components.layers.generate, components.layers.serve],
        },
        volumes: [components.volumes.db],
        boxes: [components.boxes.generate, components.boxes.serve],
        workloads: [
            components.workloads.generate { start+: { compute_resources+: { vcpu_guarantee: 15000 } } },  // override example
            components.workloads.serve,
        ],
    },
    resource_request={ vcpu_guarantee: 30000, memory_guarantee: 48 * (1 << 30) },
    disk_volume_request=data_model.disk_volume_capacity(1 << 31),
    ip6_address_request=data_model.ip6_address_network_id('_GENCFG_SEARCHPRODNETS_ROOT_')
);

// return recipe
recipe.uniform_service(
    id=locals.project_id,
    replica_set_spec=replica_set_spec,
    clusters=['SAS', 'MAN', 'VLA']
)
