/*
    nirvana_job_processor

    service.jsonnet should generate service recipe as json
    jsonnet is a data templating language - an extension of JSON
    learn more at https://jsonnet.org
*/

// import Yandex.Drug jsonnet modules
// every module contains helper-functions for generating Drug objects (replica_sets, endpoint_sets, etc.)
local awacs = import 'lib/awacs.jsonnet.TEMPLATE';  //             balancers
local data_model = import 'lib/data_model.jsonnet.TEMPLATE';  //   disk and network
local replica_set = import 'lib/replica_set.jsonnet.TEMPLATE';  // replica_set and its deployment strategies

local awacs_namespace_id = 'rsc-demo';
local id = 'drug-98-nirvana-test';
local cluster = 'MAN-PRE';  //             please, use either MAN-PRE or SAS-TEST by now
local moderators = ['yanddmi'];
local port = 8080;

// return service recipe
// json output is canonized at exectest - see ya.make and canondata nearby
{
    cubes: {  // map: cube_id->cube
        replica_set: {
            replica_set_cube: {
                cluster: cluster,
                replica_set_ref: id,
                replica_set_spec: replica_set.simple(
                    account_id='abc:service:3494',  // resources will be allocated from account's quota
                    replica_count=2,
                    degrade_level=1.0,
                    pod_agent_spec={
                        resources: {
                            layers: [{
                                id: 'nirvana_job_processor_rootfs',
                                checksum: 'MD5:2c7b8cd68209999ffc9030fe55da2151',
                                url: 'https://proxy.sandbox.yandex-team.ru/849521480',
                            }],
                        },
                        boxes: [{
                            id: 'nirvana_job_processor',
                            rootfs: {
                                layer_refs: ['nirvana_job_processor_rootfs'],
                            },
                        }],
                        workloads: [{
                            id: 'nirvana_job_processor',
                            env: [
                                { name: secret, value: { secret_env: { alias: 'nirvana_job_processor_secrets', id: secret } } }
                                for secret in [  // import from yav
                                    'NIRVANA_JOB_PROCESSOR_S3_ACCESS_KEY',
                                    'NIRVANA_JOB_PROCESSOR_S3_SECRET_KEY',
                                    'NIRVANA_JOB_PROCESSOR_YT_TOKEN',
                                    'NIRVANA_MDS_STATIC_ACCESS_KEY',
                                    'NIRVANA_MDS_STATIC_SECRET_KEY',
                                    'NIRVANA_MDS_TVM_CLIENT_ID',
                                    'NIRVANA_MDS_TVM_CLIENT_OAUTH_TOKEN',
                                    'NIRVANA_MDS_TVM_CLIENT_SECRET',
                                    'NIRVANA_SECRETS_OAUTH_TOKEN',
                                    'PGAAS_JOB_PROCESSOR_DB_TEST_PASSWORD',
                                    'SCHEDULER_YT_TOKEN',
                                ]
                            ] + [
                                { name: secret.k, value: { literal_env: { value: secret.v } } }
                                for secret in [
                                    { k: 'QLOUD_ENVIRONMENT', v: 'test' },
                                    { k: 'QLOUD_HTTP_PORT', v: std.toString(port) },
                                    { k: 'QLOUD_JAVA_OPTIONS', v: '-Dfile.encoding=UTF-8 -Xmx3200m -Djava.net.preferIPv6Addresses=true -XX:+PrintCommandLineFlags -verbose:gc -Xloggc:/dev/stdout  -XX:+PrintGCDateStamps -XX:+PrintGCTimeStamps -XX:+PrintGCDetails -XX:+PrintTenuringDistribution -XX:+PrintGCApplicationStoppedTime -XX:+DisableExplicitGC -XX:+UseConcMarkSweepGC -XX:+CMSClassUnloadingEnabled -XX:ParallelCMSThreads=2 -XX:CMSInitiatingOccupancyFraction=80' },
                                    { k: 'QLOUD_PROFILES', v: 'production' },
                                    { k: 'REDEPLOY', v: '2' },
                                ]
                            ],
                            start: {
                                command_line: 'java $QLOUD_JAVA_OPTIONS -jar /runtime.jar',
                            },
                            readiness_check: {
                                tcp_check: {
                                    port: port,
                                    time_limit: {
                                        max_restart_period_ms: 5000,
                                        min_restart_period_ms: 5000,
                                        max_execution_time_ms: 1000,
                                    },
                                },
                            },
                            box_ref: 'nirvana_job_processor',
                        }],
                        mutable_workloads: [{
                            workload_ref: 'nirvana_job_processor',
                        }],
                    },
                    resource_request={ vcpu_guarantee: 1000, memory_guarantee: 1 << 32 },
                    disk_volume_request=data_model.disk_volume_capacity(30 * (1 << 30)),
                    ip6_address_request=data_model.ip6_address_network_id('_NIRVANANETS_'),
                    secrets={
                        nirvana_job_processor_secrets: {
                            secret_id: 'sec-01d4arazzr91ewa0wn20xxgqp5',
                            secret_version: 'ver-01d4svdrtrd26h41j8y5ev2x34',
                            delegation_token: '1m9v6P2_Qk87qq1aaZHRw9NpepbLr3BGFziiKUgGSNo.1.6cb407ccf8586ad6',
                        },
                    }
                ),
            },
        },
        endpoint_set: {
            endpoint_set_cube: {  // build endpoint_set upon replica_set
                cluster: cluster,
                endpoint_set_ref: id,
                endpoint_set_spec: data_model.endpoint_set_for_replica_set(
                    replica_set_id=id,
                    port=port
                ),
            },
        },
        awacs_backend: {  // build balancer backend upon endpoint_set
            awacs_backend_cube: awacs.backend_simple(
                namespace_id=awacs_namespace_id,
                id=id,
                logins=moderators,
                yp_endpoint_sets=[awacs.yp_endpoint_set_simple(
                    endpoint_set_id=id,
                    cluster=std.asciiLower(std.strReplace(cluster, '-', '_')),  // awacs accepts underscore only
                    port=port,
                )]
            ),
        },
        awacs_upstream: {  // build balancer upstream upon backend
            awacs_upstream_cube: awacs.upstream_simple(
                namespace_id=awacs_namespace_id,
                id=id,
                logins=moderators,
                include_backends=[id]
            ),
        },
    },
}
