local data_model = import 'lib/data_model.jsonnet.TEMPLATE';
local pod_agent = import 'lib/pod_agent.jsonnet.TEMPLATE';
local replica_set = import 'lib/replica_set.jsonnet.TEMPLATE';

local locals = import 'locals.jsonnet';

{
    base_shard_generator(cluster, shard):: replica_set.simple(
        account_id='abc:service:1234',
        replica_count=16,
        pod_agent_spec=pod_agent.workload_in_box(  // we may create more boxes here - one box per every 'little shard'
            id='%s_%s' % [cluster, shard],
            layers=[
                pod_agent.layer_from_sandbox(locals.search_base_bootstrap_sbr),
            ],
            start_cmd='/search_base bootstrap --shard %s' % shard,
        ),
        resource_request={ vcpu_guarantee: 16 * 1000, memory_guarantee: 32 * (1 << 30) },
        disk_volume_request=data_model.disk_volume_capacity(100 * (1 << 30)),
        ip6_address_request=data_model.ip6_address_network_id('_GENCFG_SEARCHPRODNETS_ROOT_')
    ),
    int_shard_generator(cluster, shard):: replica_set.simple(
        account_id='abc:service:1234',
        replica_count=16,
        pod_agent_spec=pod_agent.workload_in_box(
            id='%s_%s' % [cluster, shard],
            layers=[
                pod_agent.layer_from_sandbox(locals.search_int_bootstrap_sbr),
            ],
            start_cmd='/search_int bootstrap --endpoint-set %s_%s_%s' % [locals.name, cluster, shard],  // assuming that int resolves endpoint_set
        ),
        resource_request={ vcpu_guarantee: 4 * 1000, memory_guarantee: 16 * (1 << 30) },
        disk_volume_request=data_model.disk_volume_capacity(50 * (1 << 30)),
        ip6_address_request=data_model.ip6_address_network_id('_GENCFG_SEARCHPRODNETS_ROOT_')
    ),
}
