local recipe = import 'lib/recipe.jsonnet.TEMPLATE';

local components = import 'components.jsonnet';
local locals = import 'locals.jsonnet';

local shards_list = std.range(1, locals.shards_cnt);

local base_shard = recipe.sharded_service(
    name='base',
    replica_set_generator=components.base_shard_generator,
    clusters=locals.clusters,
    shards=shards_list
);

local base_endpoints = {
    // endpoint_set for each shard
    // DRUG will support user's endpoint condition at sometime - for now endpoint is up for every alive pod
    ['endpoint_set_base_%s_%s' % [cluster, shard]]: {
        endpoint_set_cube: {
            cluster: cluster,
            endpoint_set_ref: 'base_%s_%s' % [cluster, shard],
            endpoint_set_spec: {
                pod_filter: '[/meta/pod_set_id] = "%s"' % std.strReplace('base_%s_%s' % [cluster, shard], '"', '\\"'),
            },
        },
    }
    for cluster in locals.clusters
    for shard in shards_list
};

local int_shard = recipe.sharded_service(
    name='int',
    replica_set_generator=components.int_shard_generator,
    clusters=locals.clusters,
    shards=shards_list
);

// return service recipe
// json output is canonized at exectest - see ya.make and canondata nearby
{
    cubes: base_shard.cubes + base_endpoints + int_shard.cubes,
}
