/*
    Hello World - example of Yandex.Drug service
    one replica_set with stateless http server

    service.jsonnet should generate service recipe as json
    jsonnet is a data templating language - an extension of JSON
    learn more at https://jsonnet.org
*/

// import Yandex.Drug jsonnet modules
// every module contains helper-functions for generating Drug objects (replica_sets, endpoint_sets, etc.)
local data_model = import 'lib/data_model.jsonnet.TEMPLATE';  //   disk and network
local pod_agent = import 'lib/pod_agent.jsonnet.TEMPLATE';  //     resources, boxes, workloads
local replica_set = import 'lib/replica_set.jsonnet.TEMPLATE';  // replica_set and its deployment strategies

local id = 'drug-171-tvm-tool';
local cluster = 'MAN-PRE';  //             please, use either MAN-PRE or SAS-TEST by now
local port = 4000;

// return service recipe
// json output is canonized at exectest - see ya.make and canondata nearby
{
    cubes: {  // map: cube_id->cube
        replica_set: {
            replica_set_cube: {
                cluster: cluster,
                replica_set_ref: id,
                replica_set_spec: replica_set.simple(
                    account_id='abc:service:3494',  // resources will be allocated from account's quota
                    replica_count=1,
                    degrade_level=1.0,
                    pod_agent_spec={
                        resources: {
                            layers: [pod_agent.layer_ubuntu_xenial],
                            static_resources: [
                                {
                                    id: 'tvm_tool_binary',
                                    verification: {
                                        checksum: 'MD5:53af80b8740a4c576a316f7ba0b0efda',
                                        check_period_ms: 600000,
                                    },
                                    url: 'rbtorrent:1b0e393f2fcaddc18dcbf6afa3a2de21d0ed4d76',  // sbr:870403174
                                },
                                {
                                    id: 'tvm_tool_config',
                                    verification: {
                                        checksum: 'EMPTY:',
                                        check_period_ms: 600000,
                                    },
                                    url: 'https://paste.yandex-team.ru/672232/text',
                                },
                            ],
                        },
                        boxes: [{
                            id: 'tvm_tool',
                            rootfs: {
                                layer_refs: ['UbuntuXenial'],
                            },
                            static_resources: [
                                {
                                    resource_ref: 'tvm_tool_binary',
                                    mount_point: 'tvmtool',
                                },
                                {
                                    resource_ref: 'tvm_tool_config',
                                    mount_point: 'tvmtool.conf',
                                },
                            ],
                        }],
                        workloads: [{
                            id: 'tvm_tool',
                            env: [
                                { name: 'TVMTOOl_LOCAL_AUTHTOKEN', value: { literal_env: { value: '38ac3d9cd71933fa1f3bf47cdfe8b7bf' } } },
                            ],
                            start: {
                                compute_resources: {
                                    vcpu_guarantee: 200,
                                    vcpu_limit: 200,
                                    memory_guarantee: 50 * (1 << 20),
                                    memory_limit: 50 * (1 << 20),
                                },
                                command_line: "bash -c '/tvmtool/tvmtool --config /tvmtool.conf/text --cache-dir /tvmtool --dangerous-interface ::1 --port %s >> /tvmtool/tvmtool.log 2>> /tvmtool/tvmtool_error.log'" % port,
                            },
                            box_ref: 'tvm_tool',
                        }],
                        mutable_workloads: [{
                            workload_ref: 'tvm_tool',
                        }],
                    },
                    resource_request={ vcpu_guarantee: 300, memory_guarantee: 1 << 28 },
                    disk_volume_request=data_model.disk_volume_capacity(1 << 30),
                    ip6_address_request=data_model.ip6_address_network_id('_SEARCHSAND_')
                ),
            },
        },
    },
}
