local data_model = import 'lib/data_model.jsonnet.TEMPLATE';
local pod_agent = import 'lib/pod_agent.jsonnet.TEMPLATE';
local replica_set = import 'lib/replica_set.jsonnet.TEMPLATE';

local locals = import 'locals.jsonnet';

local Aggregator(cpu, ram) = {
    replica_set_generator(cluster, shard): replica_set.simple(
        account_id='abc:service:1234',
        replica_count=16,
        pod_agent_spec=pod_agent.workload_in_box(
            id='%s_%s' % [cluster, shard],
            layers=[
                pod_agent.layer_from_sandbox(locals.yasmcore_bootstrap),
                pod_agent.layer_from_sandbox(locals.yasmcore_tar_gz),
            ],
            start_cmd='/db/yasmcore/bin/trampoline yasm-bootstrap --shard %s' % shard,
        ),
        resource_request={ vcpu_guarantee: cpu, memory_guarantee: ram },
        disk_volume_request=data_model.disk_volume_capacity(1 << 38),
        ip6_address_request=data_model.ip6_address_network_id('_GENCFG_SEARCHPRODNETS_ROOT_')
    ),
};

{
    Aggregator:: Aggregator,
}
