local recipe = import 'lib/recipe.jsonnet.TEMPLATE';

local components = import 'components.jsonnet';

local GB(gygaBytes) = gygaBytes << 30;

local shard_one = recipe.sharded_service(
    name='one',
    replica_set_generator=components.Aggregator(cpu=32000, ram=GB(64)).replica_set_generator,
    clusters=['SAS', 'MAN'],
    shards=[1, 2, 3]
);
local shard_two = recipe.sharded_service(
    name='two',
    replica_set_generator=components.Aggregator(cpu=16000, ram=GB(64)).replica_set_generator,
    clusters=['VLA'],
    shards=[1, 2, 3]
);

{
    cubes: shard_one.cubes + shard_two.cubes,
}
