#pragma once

#include <util/generic/yexception.h>

namespace NEbpfAgent {

#define DEFINE_COUNTED_EXCEPTION(TClass, TBaseClass) \
    class TClass: public TBaseClass { \
    public: \
        inline TClass() noexcept \
        { \
            ++Counter; \
        } \
        \
        static inline auto ResetCounter() { \
            auto counter = Counter; \
            Counter = 0; \
            return counter; \
        } \
        \
    private: \
        static std::size_t Counter; \
    }

    DEFINE_COUNTED_EXCEPTION(TBpfError, TSystemError);
    DEFINE_COUNTED_EXCEPTION(TCgroupError, TSystemError);

} // namespace NEbpfAgent
