#pragma once

#include <library/cpp/unistat/pusher/pusher.h>

namespace NEbpfAgent {

    enum class ESignal {
        OldKernel,
        LeakedCgroups,
        Running,
        Disabled,

        BpfErrors,
        CgroupErrors,

        //NetStatRxBytesBbSas,
        //NetStatRxBytesBbVla,
        //NetStatRxBytesBbMan,
        //NetStatRxBytesBbIva,
        //NetStatRxBytesBbMyt,

        NetStatRxBytesFbSas,
        NetStatRxBytesFbVla,
        NetStatRxBytesFbMan,
        NetStatRxBytesFbIva,
        NetStatRxBytesFbMyt,

        //NetStatTxBytesBbSas,
        //NetStatTxBytesBbVla,
        //NetStatTxBytesBbMan,
        //NetStatTxBytesBbIva,
        //NetStatTxBytesBbMyt,

        NetStatTxBytesFbSas,
        NetStatTxBytesFbVla,
        NetStatTxBytesFbMan,
        NetStatTxBytesFbIva,
        NetStatTxBytesFbMyt,
        
        TcpBytesAcked,
        TcpBytesSent,
        TcpBytesRetrans,
        TcpBytesExtRetrans,

        SignalsCount
    };

    struct TSignal {
        ESignal Signal;
        const char* Name;
        const char* Suffix;

        bool Diff = false;
        bool PrevValueSet = false;
        double PrevValue;

        const NUnistat::TIntervals Intervals;

        inline TSignal(ESignal signal, const char* name, const char* suffix, bool diff = false)
            : Signal(signal)
            , Name(name)
            , Suffix(suffix)
            , Diff(diff)
        {
        }

        inline TSignal(ESignal signal, const char* name, const char* suffix, const NUnistat::TIntervals& intervals) noexcept
            : Signal(signal)
            , Name(name)
            , Suffix(suffix)
            , Intervals(intervals)
        {
        }
    };

    extern TSignal Signals[];

    inline TString ToString(const ESignal s) {
        return Signals[static_cast<int>(s)].Name;
    }

    void StartUnistatPusher();
    void StopUnistatPusher();

    inline void PushSignal(const ESignal s, double value) {
        auto& signal = Signals[static_cast<int>(s)];
        if (signal.Diff) {
            if (!signal.PrevValueSet) {
                signal.PrevValueSet = true;
                signal.PrevValue = value;
                return;
            }
            auto tmp = value;
            value -= signal.PrevValue;
            signal.PrevValue = tmp;
        }
        TUnistatPusher::Instance().PushSignalUnsafe(s, value);
    }

    void UpdateErrorMetrics();

} // namespace NEbpfAgent
