#include <infra/ebpf-agent/lib/nets.h>

#include <util/stream/format.h>

namespace NEbpfAgent {

    const TVector<TYaNetwork> YaNetworks = {

        // --- SAS1 ---

        { HTONL(0x0c070000), 48, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c07::/48
        { HTONL(0x0c080000), 48, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c08::/48
        { HTONL(0x0c140000), 48, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c14::/48
        { HTONL(0x00008000), 50, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:8000::/50
        { HTONL(0xb0007000), 52, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:7000::/52
        { HTONL(0xb0100000), 52, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b010::/52
        { HTONL(0xb0101000), 52, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b010:1000::/52
        { HTONL(0xb010f000), 52, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b010:f000::/52
        { HTONL(0xb0203000), 52, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b020:3000::/52
        { HTONL(0x0c020000), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02::/56
        { HTONL(0x0c020100), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02:100::/56
        { HTONL(0x0c020200), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02:200::/56
        { HTONL(0x0c020500), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02:500::/56
        { HTONL(0x0c020700), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02:700::/56
        { HTONL(0x0c020b00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02:b00::/56
        { HTONL(0x0c020c00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:c02:c00::/56
        { HTONL(0xb0000100), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:100::/56
        { HTONL(0xb0000200), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:200::/56
        { HTONL(0xb0000300), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:300::/56
        { HTONL(0xb0000500), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:500::/56
        { HTONL(0xb0000600), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:600::/56
        { HTONL(0xb0000700), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:700::/56
        { HTONL(0xb0000800), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:800::/56
        { HTONL(0xb0000900), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:900::/56
        { HTONL(0xb0000a00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:a00::/56
        { HTONL(0xb0000b00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:b00::/56
        { HTONL(0xb0000c00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:c00::/56
        { HTONL(0xb0000e00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:e00::/56
        { HTONL(0xb0000f00), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b000:f00::/56
        { HTONL(0xb0401100), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b040:1100::/56
        { HTONL(0xb0401600), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b040:1600::/56
        { HTONL(0xb0601000), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b060:1000::/56
        { HTONL(0xb0601100), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b060:1100::/56
        { HTONL(0xb0601500), 56, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b060:1500::/56
        { HTONL(0xb0301000), 62, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:b030:1000::/62
        { HTONL(0x00001a00), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a00::/64
        { HTONL(0x00001a01), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a01::/64
        { HTONL(0x00001a02), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a02::/64
        { HTONL(0x00001a03), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a03::/64
        { HTONL(0x00001a04), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a04::/64
        { HTONL(0x00001a05), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a05::/64
        { HTONL(0x00001a06), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a06::/64
        { HTONL(0x00001a07), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a07::/64
        { HTONL(0x00001a08), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a08::/64
        { HTONL(0x00001a09), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a09::/64
        { HTONL(0x00001a0a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a0a::/64
        { HTONL(0x00001a0d), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a0d::/64
        { HTONL(0x00001a0e), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a0e::/64
        { HTONL(0x00001a0f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a0f::/64
        { HTONL(0x00001a10), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a10::/64
        { HTONL(0x00001a11), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a11::/64
        { HTONL(0x00001a12), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a12::/64
        { HTONL(0x00001a14), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a14::/64
        { HTONL(0x00001a15), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a15::/64
        { HTONL(0x00001a16), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a16::/64
        { HTONL(0x00001a17), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a17::/64
        { HTONL(0x00001a18), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a18::/64
        { HTONL(0x00001a19), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a19::/64
        { HTONL(0x00001a1a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a1a::/64
        { HTONL(0x00001a1b), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a1b::/64
        { HTONL(0x00001a1c), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a1c::/64
        { HTONL(0x00001a1d), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a1d::/64
        { HTONL(0x00001a1e), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a1e::/64
        { HTONL(0x00001a1f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a1f::/64
        { HTONL(0x00001a21), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a21::/64
        { HTONL(0x00001a22), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a22::/64
        { HTONL(0x00001a24), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a24::/64
        { HTONL(0x00001a25), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a25::/64
        { HTONL(0x00001a26), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a26::/64
        { HTONL(0x00001a28), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a28::/64
        { HTONL(0x00001a29), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a29::/64
        { HTONL(0x00001a2a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a2a::/64
        { HTONL(0x00001a2b), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a2b::/64
        { HTONL(0x00001a2c), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a2c::/64
        { HTONL(0x00001a2d), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a2d::/64
        { HTONL(0x00001a2e), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a2e::/64
        { HTONL(0x00001a31), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a31::/64
        { HTONL(0x00001a33), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a33::/64
        { HTONL(0x00001a34), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a34::/64
        { HTONL(0x00001a35), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a35::/64
        { HTONL(0x00001a36), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a36::/64
        { HTONL(0x00001a39), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a39::/64
        { HTONL(0x00001a3d), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a3d::/64
        { HTONL(0x00001a3e), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a3e::/64
        { HTONL(0x00001a40), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a40::/64
        { HTONL(0x00001a41), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a41::/64
        { HTONL(0x00001a42), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a42::/64
        { HTONL(0x00001a43), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a43::/64
        { HTONL(0x00001a44), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a44::/64
        { HTONL(0x00001a45), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a45::/64
        { HTONL(0x00001a46), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a46::/64
        { HTONL(0x00001a49), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a49::/64
        { HTONL(0x00001a4a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a4a::/64
        { HTONL(0x00001a4b), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a4b::/64
        { HTONL(0x00001a4c), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a4c::/64
        { HTONL(0x00001a4f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a4f::/64
        { HTONL(0x00001a51), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a51::/64
        { HTONL(0x00001a52), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a52::/64
        { HTONL(0x00001a53), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a53::/64
        { HTONL(0x00001a54), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a54::/64
        { HTONL(0x00001a55), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a55::/64
        { HTONL(0x00001a56), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a56::/64
        { HTONL(0x00001a57), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a57::/64
        { HTONL(0x00001a58), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a58::/64
        { HTONL(0x00001a59), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a59::/64
        { HTONL(0x00001a5a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a5a::/64
        { HTONL(0x00001a5c), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a5c::/64
        { HTONL(0x00001a5e), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a5e::/64
        { HTONL(0x00001a5f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a5f::/64
        { HTONL(0x00001a60), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a60::/64
        { HTONL(0x00001a61), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a61::/64
        { HTONL(0x00001a62), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a62::/64
        { HTONL(0x00001a68), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a68::/64
        { HTONL(0x00001a69), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a69::/64
        { HTONL(0x00001a6a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a6a::/64
        { HTONL(0x00001a6b), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a6b::/64
        { HTONL(0x00001a6f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a6f::/64
        { HTONL(0x00001a70), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a70::/64
        { HTONL(0x00001a71), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a71::/64
        { HTONL(0x00001a72), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a72::/64
        { HTONL(0x00001a75), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a75::/64
        { HTONL(0x00001a76), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a76::/64
        { HTONL(0x00001a77), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a77::/64
        { HTONL(0x00001a78), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a78::/64
        { HTONL(0x00001a7a), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a7a::/64
        { HTONL(0x00001a7c), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a7c::/64
        { HTONL(0x00001a7f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a7f::/64
        { HTONL(0x00001a81), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a81::/64
        { HTONL(0x00001a82), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a82::/64
        { HTONL(0x00001a83), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a83::/64
        { HTONL(0x00001a85), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a85::/64
        { HTONL(0x00001a8f), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a8f::/64
        { HTONL(0x00001a90), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a90::/64
        { HTONL(0x00001a91), 64, DC_SAS1, NET_BACKBONE }, // 2a02:6b8:0:1a91::/64

        { HTONL(0xfc000000), 48, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc00::/48
        { HTONL(0xfc0e0000), 48, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc0e::/48
        { HTONL(0xfc0f0000), 48, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc0f::/48
        { HTONL(0xf0000000), 52, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:f000::/52
        { HTONL(0xf0101000), 52, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:f010:1000::/52
        { HTONL(0xf0200000), 52, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:f020::/52
        { HTONL(0xf0301000), 52, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:f030:1000::/52
        { HTONL(0xf0009300), 56, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:f000:9300::/56
        { HTONL(0xfc020200), 56, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc02:200::/56
        { HTONL(0xfc020300), 56, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc02:300::/56
        { HTONL(0xfc020500), 56, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc02:500::/56
        { HTONL(0xfc020600), 56, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:fc02:600::/56
        { HTONL(0x00000a1a), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:a1a::/64
        { HTONL(0x00000a34), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:a34::/64
        { HTONL(0x00000a4a), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:a4a::/64
        { HTONL(0x00000a66), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:a66::/64
        { HTONL(0x00000ab7), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:ab7::/64
        { HTONL(0x00000ad0), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:ad0::/64
        { HTONL(0x00000ae9), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:ae9::/64
        { HTONL(0x00000aed), 64, DC_SAS1, NET_FASTBONE }, // 2a02:6b8:0:aed::/64

        // --- SAS2 ---

        { HTONL(0x0c100000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c10::/48
        { HTONL(0x0c110000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c11::/48
        { HTONL(0x0c160000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c16::/48
        { HTONL(0x0c1b0000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c1b::/48
        { HTONL(0x0c1c0000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c1c::/48
        { HTONL(0x0c1e0000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c1e::/48
        { HTONL(0x0c210000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c21::/48
        { HTONL(0x0c230000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c23::/48
        { HTONL(0x0c240000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c24::/48
        { HTONL(0x0c270000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c27::/48
        { HTONL(0x0c280000), 48, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c28::/48
        { HTONL(0xbf001000), 52, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:bf00:1000::/52
        { HTONL(0x0c020300), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0300::/56
        { HTONL(0x0c020400), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0400::/56
        { HTONL(0x0c020600), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0600::/56
        { HTONL(0x0c020800), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0800::/56
        { HTONL(0x0c020900), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0900::/56
        { HTONL(0x0c020d00), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0d00::/56
        { HTONL(0x0c020e00), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0e00::/56
        { HTONL(0x0c020f00), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:0f00::/56
        { HTONL(0x0c021000), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:1000::/56
        { HTONL(0x0c021100), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:1100::/56
        { HTONL(0x0c021200), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:1200::/56
        { HTONL(0x0c021300), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:1300::/56
        { HTONL(0x0c021400), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:c02:1400::/56
        { HTONL(0xb0000400), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:b000:400::/56
        { HTONL(0xb0401b00), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:b040:1b00::/56
        { HTONL(0xb0401c00), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:b040:1c00::/56
        { HTONL(0xb0601200), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:b060:1200::/56
        { HTONL(0xb0601300), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:b060:1300::/56
        { HTONL(0xb0601400), 56, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:b060:1400::/56
        { HTONL(0x00001a3f), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a3f::/64
        { HTONL(0x00001a63), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a63::/64
        { HTONL(0x00001a65), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a65::/64
        { HTONL(0x00001a66), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a66::/64
        { HTONL(0x00001a67), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a67::/64
        { HTONL(0x00001a6d), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a6d::/64
        { HTONL(0x00001a6e), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a6e::/64
        { HTONL(0x00001a73), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a73::/64
        { HTONL(0x00001a74), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a74::/64
        { HTONL(0x00001a7b), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a7b::/64
        { HTONL(0x00001a92), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a92::/64
        { HTONL(0x00001a93), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a93::/64
        { HTONL(0x00001a94), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a94::/64
        { HTONL(0x00001a95), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a95::/64
        { HTONL(0x00001a96), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a96::/64
        { HTONL(0x00001a97), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a97::/64
        { HTONL(0x00001a98), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a98::/64
        { HTONL(0x00001a99), 64, DC_SAS2, NET_BACKBONE }, // 2a02:6b8:0:1a99::/64

        { HTONL(0xfc0a0000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc0a::/48
        { HTONL(0xfc0b0000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc0b::/48
        { HTONL(0xfc170000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc17::/48
        { HTONL(0xfc1c0000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc1c::/48
        { HTONL(0xfc1d0000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc1d::/48
        { HTONL(0xfc1f0000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc1f::/48
        { HTONL(0xfc220000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc22::/48
        { HTONL(0xfc230000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc23::/48
        { HTONL(0xfc240000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc24::/48
        { HTONL(0xfc270000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc27::/48
        { HTONL(0xfc280000), 48, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc28::/48
        { HTONL(0xf0005200), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:f000:5200::/56
        { HTONL(0xf0009100), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:f000:9100::/56
        { HTONL(0xf0009200), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:f000:9200::/56
        { HTONL(0xfc020000), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02::/56
        { HTONL(0xfc020100), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:100::/56
        { HTONL(0xfc020400), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:400::/56
        { HTONL(0xfc020700), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:700::/56
        { HTONL(0xfc020800), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:800::/56
        { HTONL(0xfc020900), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:900::/56
        { HTONL(0xfc020a00), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:a00::/56
        { HTONL(0xfc021100), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:1100::/56
        { HTONL(0xfc021200), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:1200::/56
        { HTONL(0xfc021300), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:1300::/56
        { HTONL(0xfc021400), 56, DC_SAS2, NET_FASTBONE }, // 2a02:6b8:fc02:1400::/56

        // --- VLA ---

        { HTONL(0x0c0d0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c0d::/48
        { HTONL(0x0c0e0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c0e::/48
        { HTONL(0x0c0f0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c0f::/48
        { HTONL(0x0c150000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c15::/48
        { HTONL(0x0c170000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c17::/48
        { HTONL(0x0c180000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c18::/48
        { HTONL(0x0c190000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c19::/48
        { HTONL(0x0c1d0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c1d::/48
        { HTONL(0x0c1f0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c1f::/48
        { HTONL(0x0c200000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c20::/48
        { HTONL(0x0c220000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c22::/48
        { HTONL(0x0c290000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c29::/48
        { HTONL(0x0c2a0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c2a::/48
        { HTONL(0x0c2b0000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:c2b::/48
        { HTONL(0xb0700000), 48, DC_VLA, NET_BACKBONE }, // 2a02:6b8:b070::/48
        { HTONL(0xbf000000), 52, DC_VLA, NET_BACKBONE }, // 2a02:6b8:bf00::/52
        { HTONL(0x00000300), 56, DC_VLA, NET_BACKBONE }, // 2a02:6b8:0:300::/56

        { HTONL(0xfc090000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc09::/48
        { HTONL(0xfc140000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc14::/48
        { HTONL(0xfc150000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc15::/48
        { HTONL(0xfc160000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc16::/48
        { HTONL(0xfc180000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc18::/48
        { HTONL(0xfc190000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc19::/48
        { HTONL(0xfc1a0000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc1a::/48
        { HTONL(0xfc1e0000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc1e::/48
        { HTONL(0xfc200000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc20::/48
        { HTONL(0xfc210000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc21::/48
        { HTONL(0xfc290000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc29::/48
        { HTONL(0xfc2a0000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc2a::/48
        { HTONL(0xfc2b0000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc2b::/48
        { HTONL(0xfc2c0000), 48, DC_VLA, NET_FASTBONE }, // 2a02:6b8:fc2c::/48

        // --- VLX ---

        { HTONL(0x0c330000), 48, DC_VLX, NET_BACKBONE }, // 2a02:6b8:c33::/48
        { HTONL(0x0c340000), 48, DC_VLX, NET_BACKBONE }, // 2a02:6b8:c34::/48
        { HTONL(0xb0750000), 48, DC_VLX, NET_BACKBONE }, // 2a02:6b8:b075::/48
        { HTONL(0x00000b00), 56, DC_VLX, NET_BACKBONE }, // 2a02:6b8:0:b00::/56

        { HTONL(0xfc330000), 48, DC_VLX, NET_FASTBONE }, // 2a02:6b8:fc33::/48
        { HTONL(0xfc340000), 48, DC_VLX, NET_FASTBONE }, // 2a02:6b8:fc34::/48

        // --- MAN ---

        { HTONL(0x0c010000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c01::/48
        { HTONL(0x0c090000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c09::/48
        { HTONL(0x0c0a0000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c0a::/48
        { HTONL(0x0c0b0000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c0b::/48
        { HTONL(0x0c130000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c13::/48
        { HTONL(0x0c1a0000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c1a::/48
        { HTONL(0x0c250000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c25::/48
        { HTONL(0x0c260000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:c26::/48
        { HTONL(0xb0110000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b011::/48
        { HTONL(0xb0720000), 48, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b072::/48
        { HTONL(0xb0006000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b000:6000::/52
        { HTONL(0xb000b000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b000:b000::/52
        { HTONL(0xb010a000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b010:a000::/52
        { HTONL(0xb01f0000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b01f::/52
        { HTONL(0xb0205000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b020:5000::/52
        { HTONL(0xb0403000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b040:3000::/52
        { HTONL(0xb0600000), 52, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b060::/52
        { HTONL(0x00000e00), 56, DC_MAN, NET_BACKBONE }, // 2a02:6b8:0:e00::/56
        { HTONL(0xb010d010), 60, DC_MAN, NET_BACKBONE }, // 2a02:6b8:b010:d010::/60

        { HTONL(0xfc010000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc01::/48
        { HTONL(0xfc0d0000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc0d::/48
        { HTONL(0xfc110000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc11::/48
        { HTONL(0xfc120000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc12::/48
        { HTONL(0xfc130000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc13::/48
        { HTONL(0xfc1b0000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc1b::/48
        { HTONL(0xfc250000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc25::/48
        { HTONL(0xfc260000), 48, DC_MAN, NET_FASTBONE }, // 2a02:6b8:fc26::/48
        { HTONL(0xf0001000), 52, DC_MAN, NET_FASTBONE }, // 2a02:6b8:f000:1000::/52
        { HTONL(0xf0002000), 52, DC_MAN, NET_FASTBONE }, // 2a02:6b8:f000:2000::/52
        { HTONL(0xf0004000), 52, DC_MAN, NET_FASTBONE }, // 2a02:6b8:f000:4000::/52
        { HTONL(0xf0106000), 52, DC_MAN, NET_FASTBONE }, // 2a02:6b8:f010:6000::/52
        { HTONL(0xf0205000), 52, DC_MAN, NET_FASTBONE }, // 2a02:6b8:f020:5000::/52
        { HTONL(0xf0300000), 52, DC_MAN, NET_FASTBONE }, // 2a02:6b8:f030::/52

        // --- IVA ---

        { HTONL(0x0c040000), 48, DC_IVA, NET_BACKBONE }, // 2a02:6b8:c04::/48
        { HTONL(0x0c0c0000), 48, DC_IVA, NET_BACKBONE }, // 2a02:6b8:c0c::/48
        { HTONL(0xb0740000), 48, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b074::/48
        { HTONL(0xb0003000), 52, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b000:3000::/52
        { HTONL(0xb0104000), 52, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b010:4000::/52
        { HTONL(0xb0105000), 52, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b010:5000::/52
        { HTONL(0xb0200000), 52, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b020::/52
        { HTONL(0xb0303000), 52, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b030:3000::/52
        { HTONL(0xb0400000), 52, DC_IVA, NET_BACKBONE }, // 2a02:6b8:b040::/52
        { HTONL(0x00000200), 56, DC_IVA, NET_BACKBONE }, // 2a02:6b8:0:200::/56
        { HTONL(0x00000800), 56, DC_IVA, NET_BACKBONE }, // 2a02:6b8:0:800::/56
        { HTONL(0x00001600), 56, DC_IVA, NET_BACKBONE }, // 2a02:6b8:0:1600::/56

        { HTONL(0xfc040000), 48, DC_IVA, NET_FASTBONE }, // 2a02:6b8:fc04::/48
        { HTONL(0xfc080000), 48, DC_IVA, NET_FASTBONE }, // 2a02:6b8:fc08::/48
        { HTONL(0xf0006000), 52, DC_IVA, NET_FASTBONE }, // 2a02:6b8:f000:6000::/52
        { HTONL(0xf0103000), 52, DC_IVA, NET_FASTBONE }, // 2a02:6b8:f010:3000::/52
        { HTONL(0xf0201000), 52, DC_IVA, NET_FASTBONE }, // 2a02:6b8:f020:1000::/52
        { HTONL(0xf0302000), 52, DC_IVA, NET_FASTBONE }, // 2a02:6b8:f030:2000::/52
        { HTONL(0x00000a03), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a03::/64
        { HTONL(0x00000a06), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a06::/64
        { HTONL(0x00000a0b), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a0b::/64
        { HTONL(0x00000a0d), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a0d::/64
        { HTONL(0x00000a12), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a12::/64
        { HTONL(0x00000a19), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a19::/64
        { HTONL(0x00000a62), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:a62::/64
        { HTONL(0x00000ab0), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:ab0::/64
        { HTONL(0x00000ae3), 64, DC_IVA, NET_FASTBONE }, // 2a02:6b8:0:ae3::/64

        // --- MYT ---

        { HTONL(0x0c000000), 48, DC_MYT, NET_BACKBONE }, // 2a02:6b8:c00::/48
        { HTONL(0x0c030000), 48, DC_MYT, NET_BACKBONE }, // 2a02:6b8:c03::/48
        { HTONL(0x0c050000), 48, DC_MYT, NET_BACKBONE }, // 2a02:6b8:c05::/48
        { HTONL(0x0c120000), 48, DC_MYT, NET_BACKBONE }, // 2a02:6b8:c12::/48
        { HTONL(0xb0730000), 48, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b073::/48
        { HTONL(0xb0005000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b000:5000::/52
        { HTONL(0xb0008000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b000:8000::/52
        { HTONL(0xb0009000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b000:9000::/52
        { HTONL(0xb000a000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b000:a000::/52
        { HTONL(0xb0107000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b010:7000::/52
        { HTONL(0xb0109000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b010:9000::/52
        { HTONL(0xb0120000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b012::/52
        { HTONL(0xb0204000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b020:4000::/52
        { HTONL(0xb0304000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b030:4000::/52
        { HTONL(0xb0405000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b040:5000::/52
        { HTONL(0xb0602000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:b060:2000::/52
        { HTONL(0xbf002000), 52, DC_MYT, NET_BACKBONE }, // 2a02:6b8:bf00:2000::/52
        { HTONL(0x00000600), 56, DC_MYT, NET_BACKBONE }, // 2a02:6b8:0:600::/56
        { HTONL(0x00001400), 56, DC_MYT, NET_BACKBONE }, // 2a02:6b8:0:1400::/56

        { HTONL(0xfc030000), 48, DC_MYT, NET_FASTBONE }, // 2a02:6b8:fc03::/48
        { HTONL(0xfc050000), 48, DC_MYT, NET_FASTBONE }, // 2a02:6b8:fc05::/48
        { HTONL(0xfc0c0000), 48, DC_MYT, NET_FASTBONE }, // 2a02:6b8:fc0c::/48
        { HTONL(0xfc100000), 48, DC_MYT, NET_FASTBONE }, // 2a02:6b8:fc10::/48
        { HTONL(0xf0007000), 52, DC_MYT, NET_FASTBONE }, // 2a02:6b8:f000:7000::/52
        { HTONL(0xf0104000), 52, DC_MYT, NET_FASTBONE }, // 2a02:6b8:f010:4000::/52
        { HTONL(0xf0202000), 52, DC_MYT, NET_FASTBONE }, // 2a02:6b8:f020:2000::/52
        { HTONL(0xf0303000), 52, DC_MYT, NET_FASTBONE }, // 2a02:6b8:f030:3000::/52
        { HTONL(0x00000a01), 64, DC_MYT, NET_FASTBONE }, // 2a02:6b8:0:a01::/64
        { HTONL(0x00000a11), 64, DC_MYT, NET_FASTBONE }, // 2a02:6b8:0:a11::/64
        { HTONL(0x00000a18), 64, DC_MYT, NET_FASTBONE }, // 2a02:6b8:0:a18::/64
        { HTONL(0x00000a63), 64, DC_MYT, NET_FASTBONE }, // 2a02:6b8:0:a63::/64
        { HTONL(0x00000ab5), 64, DC_MYT, NET_FASTBONE }, // 2a02:6b8:0:ab5::/64
        { HTONL(0x00000ae1), 64, DC_MYT, NET_FASTBONE }, // 2a02:6b8:0:ae1::/64
    };

    const TVector<std::pair<__u32, ETrafficClass>> ProjectIds = {
        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTARNOLDNETS_
        { HTONL(0x00004496), TC_CS4_ECN },
        { HTONL(0x010d5ae7), TC_CS4_ECN },
        { HTONL(0x010d5b4d), TC_CS4_ECN },
        { HTONL(0x010d5b9b), TC_CS4_ECN },
        { HTONL(0x010d5beb), TC_CS4_ECN },
        { HTONL(0x010d5bef), TC_CS4_ECN },
        { HTONL(0x010d5bf0), TC_CS4_ECN },
        { HTONL(0x010d6b93), TC_CS4_ECN },
        { HTONL(0x010dba41), TC_CS4_ECN },
        { HTONL(0x010dbddf), TC_CS4_ECN },
        { HTONL(0x010dc129), TC_CS4_ECN },
        { HTONL(0x010dca69), TC_CS4_ECN },
        { HTONL(0x010dd46c), TC_CS4_ECN },
        { HTONL(0x010df379), TC_CS4_ECN },
        { HTONL(0x010e0616), TC_CS4_ECN },
        { HTONL(0x010e0e4e), TC_CS4_ECN },
        { HTONL(0x010eaa5f), TC_CS4_ECN },
        { HTONL(0x010eb0fd), TC_CS4_ECN },
        { HTONL(0x010ef338), TC_CS4_ECN },
        { HTONL(0x010ef485), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTZENONETS_
        { HTONL(0x000047f7), TC_CS4_ECN },
        { HTONL(0x010ec3d6), TC_CS4_ECN },
        { HTONL(0x010ec3d7), TC_CS4_ECN },
        { HTONL(0x010ec3d9), TC_CS4_ECN },
        { HTONL(0x010ec3da), TC_CS4_ECN },
        { HTONL(0x010ec3e0), TC_CS4_ECN },
        { HTONL(0x010ec3e2), TC_CS4_ECN },
        { HTONL(0x010ec3e3), TC_CS4_ECN },
        { HTONL(0x010ec3e5), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTHAHNNETS__
        { HTONL(0x00004397), TC_CS4_ECN },
        { HTONL(0x010de7ae), TC_CS4_ECN },
        { HTONL(0x010dff1b), TC_CS4_ECN },
        { HTONL(0x010dff1e), TC_CS4_ECN },
        { HTONL(0x010e0038), TC_CS4_ECN },
        { HTONL(0x010e0039), TC_CS4_ECN },
        { HTONL(0x010e003a), TC_CS4_ECN },
        { HTONL(0x010e003d), TC_CS4_ECN },
        { HTONL(0x010e003e), TC_CS4_ECN },
        { HTONL(0x010ec074), TC_CS4_ECN },
        { HTONL(0x010ec128), TC_CS4_ECN },
        { HTONL(0x010ec12a), TC_CS4_ECN },
        { HTONL(0x010ec12b), TC_CS4_ECN },
        { HTONL(0x010ec12c), TC_CS4_ECN },
        { HTONL(0x010ec12d), TC_CS4_ECN },
        { HTONL(0x010ec3b4), TC_CS4_ECN },
        { HTONL(0x010ec3b5), TC_CS4_ECN },
        { HTONL(0x010ec3b7), TC_CS4_ECN },
        { HTONL(0x010ec3b8), TC_CS4_ECN },
        { HTONL(0x010ec3b9), TC_CS4_ECN },
        { HTONL(0x010ec3bb), TC_CS4_ECN },
        { HTONL(0x010ec944), TC_CS4_ECN },
        { HTONL(0x010ec945), TC_CS4_ECN },
        { HTONL(0x010ec946), TC_CS4_ECN },
        { HTONL(0x010ecf8d), TC_CS4_ECN },
        { HTONL(0x010ecf8f), TC_CS4_ECN },
        { HTONL(0x010ed3b6), TC_CS4_ECN },
        { HTONL(0x010ed3b7), TC_CS4_ECN },
        { HTONL(0x010ef215), TC_CS4_ECN },
        { HTONL(0x010efb3e), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTSENECASASNETS_
        { HTONL(0x000044b1), TC_CS4_ECN },
        { HTONL(0x010dadb5), TC_CS4_ECN },
        { HTONL(0x010dadb9), TC_CS4_ECN },
        { HTONL(0x010dadbd), TC_CS4_ECN },
        { HTONL(0x010dbb54), TC_CS4_ECN },
        { HTONL(0x010dc945), TC_CS4_ECN },
        { HTONL(0x010dc948), TC_CS4_ECN },
        { HTONL(0x010dc949), TC_CS4_ECN },
        { HTONL(0x010dceef), TC_CS4_ECN },
        { HTONL(0x010ed67a), TC_CS4_ECN },
        { HTONL(0x010ed67b), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTSENECAVLANETS_
        { HTONL(0x0000441a), TC_CS4_ECN },
        { HTONL(0x010d6ad8), TC_CS4_ECN },
        { HTONL(0x010d6adb), TC_CS4_ECN },
        { HTONL(0x010d6ae1), TC_CS4_ECN },
        { HTONL(0x010d6ae6), TC_CS4_ECN },
        { HTONL(0x010d6aea), TC_CS4_ECN },
        { HTONL(0x010d6aed), TC_CS4_ECN },
        { HTONL(0x010d6af1), TC_CS4_ECN },
        { HTONL(0x010d6af3), TC_CS4_ECN },
        { HTONL(0x010da795), TC_CS4_ECN },
        { HTONL(0x010eb281), TC_CS4_ECN },
        { HTONL(0x010ed686), TC_CS4_ECN },
        { HTONL(0x010ed687), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTSENECAMANNETS_
        { HTONL(0x00004603), TC_CS4_ECN },
        { HTONL(0x010df3b6), TC_CS4_ECN },
        { HTONL(0x010df3cf), TC_CS4_ECN },
        { HTONL(0x010df3d1), TC_CS4_ECN },
        { HTONL(0x010df3e9), TC_CS4_ECN },
        { HTONL(0x010df3ec), TC_CS4_ECN },
        { HTONL(0x010df3ee), TC_CS4_ECN },
        { HTONL(0x010df3fe), TC_CS4_ECN },
        { HTONL(0x010df401), TC_CS4_ECN },
        { HTONL(0x010df450), TC_CS4_ECN },
        { HTONL(0x010df451), TC_CS4_ECN },
        { HTONL(0x010df651), TC_CS4_ECN },
        { HTONL(0x010ef444), TC_CS4_ECN },
        { HTONL(0x010ef445), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTADANETS_
        { HTONL(0x00004d42), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTBOHRNETS_
        { HTONL(0x00004396), TC_CS4_ECN },
        { HTONL(0x010eb120), TC_CS4_ECN },
        { HTONL(0x010eb121), TC_CS4_ECN },
        { HTONL(0x010eb123), TC_CS4_ECN },
        { HTONL(0x010eb125), TC_CS4_ECN },
        { HTONL(0x010eb126), TC_CS4_ECN },
        { HTONL(0x010eb127), TC_CS4_ECN },
        { HTONL(0x010eb129), TC_CS4_ECN },
        { HTONL(0x010eb12a), TC_CS4_ECN },
        { HTONL(0x010eb12b), TC_CS4_ECN },
        { HTONL(0x010eb12d), TC_CS4_ECN },
        { HTONL(0x010eb9f2), TC_CS4_ECN },
        { HTONL(0x010ebc69), TC_CS4_ECN },
        { HTONL(0x010ebc6a), TC_CS4_ECN },
        { HTONL(0x010ebc6b), TC_CS4_ECN },
        { HTONL(0x010ebc6c), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTFREUDNETS_
        { HTONL(0x000049b5), TC_CS4_ECN },
        { HTONL(0x01027a84), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTHUMENETS_
        { HTONL(0x00000536), TC_CS4_ECN },
        { HTONL(0x010d2342), TC_CS4_ECN },
        { HTONL(0x010ead5b), TC_CS4_ECN },
        { HTONL(0x010ead5c), TC_CS4_ECN },
        { HTONL(0x010ead5e), TC_CS4_ECN },
        { HTONL(0x010ead61), TC_CS4_ECN },
        { HTONL(0x010ead62), TC_CS4_ECN },
        { HTONL(0x010ead64), TC_CS4_ECN },
        { HTONL(0x010ead65), TC_CS4_ECN },
        { HTONL(0x010ead6a), TC_CS4_ECN },
        { HTONL(0x010eadb0), TC_CS4_ECN },
        { HTONL(0x010eb099), TC_CS4_ECN },
        { HTONL(0x010eb09a), TC_CS4_ECN },
        { HTONL(0x010eb161), TC_CS4_ECN },
        { HTONL(0x010eb4df), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTLANDAUNETS_
        { HTONL(0x0000451f), TC_CS4_ECN },
        { HTONL(0x010dc977), TC_CS4_ECN },
        { HTONL(0x010dc978), TC_CS4_ECN },
        { HTONL(0x010dc979), TC_CS4_ECN },
        { HTONL(0x010dc97a), TC_CS4_ECN },
        { HTONL(0x010dc97b), TC_CS4_ECN },
        { HTONL(0x010dc97e), TC_CS4_ECN },
        { HTONL(0x010dc97f), TC_CS4_ECN },
        { HTONL(0x010dcad8), TC_CS4_ECN },
        { HTONL(0x010e00b5), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTLOCKENETS_
        { HTONL(0x00000549), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTMARKOVNETS_
        { HTONL(0x000044a6), TC_CS4_ECN },
        { HTONL(0x010dcbd0), TC_CS4_ECN },
        { HTONL(0x010dcbd3), TC_CS4_ECN },
        { HTONL(0x010dcbd7), TC_CS4_ECN },
        { HTONL(0x010dcc9a), TC_CS4_ECN },
        { HTONL(0x010dcc9c), TC_CS4_ECN },
        { HTONL(0x010dcc9d), TC_CS4_ECN },
        { HTONL(0x010dd24c), TC_CS4_ECN },
        { HTONL(0x010dd24d), TC_CS4_ECN },
        { HTONL(0x010dd251), TC_CS4_ECN },
        { HTONL(0x010df184), TC_CS4_ECN },
        { HTONL(0x010df185), TC_CS4_ECN },
        { HTONL(0x010df1c1), TC_CS4_ECN },
        { HTONL(0x010df1c2), TC_CS4_ECN },
        { HTONL(0x010df1c6), TC_CS4_ECN },
        { HTONL(0x010df1c7), TC_CS4_ECN },
        { HTONL(0x010df1c8), TC_CS4_ECN },
        { HTONL(0x010df1c9), TC_CS4_ECN },
        { HTONL(0x010ec7b0), TC_CS4_ECN },
        { HTONL(0x010ec7b4), TC_CS4_ECN },
        { HTONL(0x010ec7b6), TC_CS4_ECN },
        { HTONL(0x010ec7b7), TC_CS4_ECN },
        { HTONL(0x010ec7b8), TC_CS4_ECN },
        { HTONL(0x010ec7b9), TC_CS4_ECN },
        { HTONL(0x010ec7bc), TC_CS4_ECN },
        { HTONL(0x010ec7be), TC_CS4_ECN },
        { HTONL(0x010ec8e3), TC_CS4_ECN },
        { HTONL(0x010ec8e4), TC_CS4_ECN },
        { HTONL(0x010ec8e5), TC_CS4_ECN },
        { HTONL(0x010ec8e7), TC_CS4_ECN },
        { HTONL(0x010ec8f4), TC_CS4_ECN },
        { HTONL(0x010ec957), TC_CS4_ECN },
        { HTONL(0x010ec958), TC_CS4_ECN },
        { HTONL(0x010ec959), TC_CS4_ECN },
        { HTONL(0x010ef4a4), TC_CS4_ECN },
        { HTONL(0x010ef4a5), TC_CS4_ECN },
        { HTONL(0x010ef4a6), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTNASHNETS_
        { HTONL(0x00004fe0), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTPYTHIANETS_
        { HTONL(0x0000460d), TC_CS4_ECN },
        { HTONL(0x010df7e6), TC_CS4_ECN },
        { HTONL(0x010df7e7), TC_CS4_ECN },
        { HTONL(0x010df7e8), TC_CS4_ECN },
        { HTONL(0x010df7ea), TC_CS4_ECN },
        { HTONL(0x010df7eb), TC_CS4_ECN },
        { HTONL(0x010df7ec), TC_CS4_ECN },
        { HTONL(0x010df7ed), TC_CS4_ECN },
        { HTONL(0x010df7ef), TC_CS4_ECN },
        { HTONL(0x010df7f2), TC_CS4_ECN },
        { HTONL(0x010df7f5), TC_CS4_ECN },
        { HTONL(0x010df7f7), TC_CS4_ECN },
        { HTONL(0x010df7f8), TC_CS4_ECN },
        { HTONL(0x010e0aa4), TC_CS4_ECN },
        { HTONL(0x010e0aa5), TC_CS4_ECN },
        { HTONL(0x010e0aa6), TC_CS4_ECN },
        { HTONL(0x010e0aac), TC_CS4_ECN },
        { HTONL(0x010e0aaf), TC_CS4_ECN },
        { HTONL(0x010e0ab7), TC_CS4_ECN },
        { HTONL(0x010e0ab8), TC_CS4_ECN },
        { HTONL(0x010e0ac2), TC_CS4_ECN },
        { HTONL(0x010e0ac3), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTSOCRATESNETS_
        { HTONL(0x00004507), TC_CS4_ECN },
        { HTONL(0x010e0b0c), TC_CS4_ECN },
        { HTONL(0x010e0b10), TC_CS4_ECN },
        { HTONL(0x010e0b15), TC_CS4_ECN },
        { HTONL(0x010e0b24), TC_CS4_ECN },
        { HTONL(0x010e0b29), TC_CS4_ECN },
        { HTONL(0x010e0b2c), TC_CS4_ECN },
        { HTONL(0x010e0b2e), TC_CS4_ECN },
        { HTONL(0x010e0b2f), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_YTVANGANETS_
        { HTONL(0x00004a74), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_NIRVANA_VANILLA_JOB_NETS_
        { HTONL(0x00004456), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_NIRVANA_REGULAR_JOB_NETS_
        { HTONL(0x00004457), TC_CS4_ECN },

        // https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_NIRVANA_SPECIAL_JOB_NETS_
        { HTONL(0x00004769), TC_CS4_ECN },
    };

    IOutputStream& operator<<(IOutputStream& out, const TYaNetwork& net) noexcept {
        return out << Hex(HTONL(net.Network)) << " " << static_cast<int>(net.PrefixLen);
    }

} // namespace NEbpfAgent
