#pragma once

#include <infra/ebpf-agent/lib/log.h>

#include <util/datetime/base.h>

namespace NEbpfAgent {

    template <typename R, typename... Args>
    inline R MeasureExecTime(const char* action, R (*f)(Args...), Args... args) {
        auto start = TInstant::Now();
        auto r = f(args...);
        auto finish = TInstant::Now();
        INFO_LOG << action << " took " << (finish - start).MilliSeconds() << " ms" << Endl;
        return r;
    }

    template <typename... Args>
    inline void MeasureExecTime(const char* action, void (*f)(Args...), Args... args) {
        auto start = TInstant::Now();
        try {
            f(args...);
        } catch (...) {
            ERROR_LOG << action << " failed: " << CurrentExceptionMessage() << Endl;
            return;
        }
        auto finish = TInstant::Now();
        INFO_LOG << action << " took " << (finish - start).MilliSeconds() << " ms" << Endl;
    }

} // namespace NEbpfAgent
