#pragma once

#include <infra/ebpf-agent/lib/metrics.h>

#include <infra/ebpf-agent/progs/include/defs.h>

#include <util/generic/strbuf.h>

namespace NEbpfAgent {

    const TString& KernelVersion();
    int CompareKernelVersion(const TStringBuf& version);
    bool IsExtendedTcpCountersSupported();
    unsigned int GetJiffieMs();
    std::tuple<TStringBuf, ESignal> CheckPrerequisites(bool forceRun);

    TString FindCgroupRoot(bool throwOnError = true);
    ui64 GetCgroupId(const TString& path);
    struct TCgroupStat {
        ui64 Descendants = 0;
        ui64 DyingDescendants = 0;
    };
    TCgroupStat GetCgroupStat(const TString& path);

    EDatacenter GetMyDatacenter();
    TString DatacenterToString(EDatacenter);

    bool SetMlockLimit(size_t bytes);

    void CleanupNetNamespaces();
    void SetupNetNamespaces();

} // namespace NEbpfAgent
