#!/bin/bash

if [[ $# -ne 2 ]] ; then
    echo 'Two arguments needed!'
    exit 1
fi

obj=$1
generated=$2
prog=$(basename $obj .o)
prog_upper=$(echo ${prog} | tr '[:lower:]' '[:upper:]')
tag=$(./get_tag.sh $obj)
if [[ -z "$tag" ]] ; then
    echo 'Failed to get program tag!'
    exit 1
fi

cat > $generated << EOF
#pragma once
// Automatically generated file. Do not edit!

namespace NEbpfAgent {

const char BPF_${prog_upper}_NAME[] = "${prog}";
static_assert(sizeof(BPF_${prog_upper}_NAME) <= BPF_OBJ_NAME_LEN);

const char BPF_${prog_upper}_TAG[] = "${tag}";
static_assert(sizeof(BPF_${prog_upper}_TAG) == 2 * BPF_TAG_SIZE + 1);

const unsigned char bpf_${prog}_bytes[] = {
$(xxd -i $obj | tail -n+2 | head -n-1 | sed 's/  /    /')
unsigned int bpf_${prog}_size = sizeof(bpf_${prog}_bytes);

} // namespace NEbpfAgent
EOF
