#!/bin/bash

if [[ $# -ne 1 ]] ; then
    echo "Usage: $0 prog.o"
    exit 1
fi

obj=$1
pinned=/tmp/bpffs/prog

bpftool=$(ya tool bpftool --print-path)

mkdir -p /tmp/bpffs
sudo mount -t bpf bpf /tmp/bpffs

sudo $bpftool prog load $obj $pinned
tag=$(sudo $bpftool --json prog show pinned $pinned | python -c 'import sys, json; print(json.load(sys.stdin)["tag"])')
sudo rm -rf $pinned

sudo umount -f /tmp/bpffs
rmdir /tmp/bpffs

echo $tag
