#pragma once

#include <netinet/tcp.h>
#include <linux/in.h>
#include <linux/in6.h>

#include <bpf_helpers.h>

#include <stdbool.h>

#include "utils.h"
#include "defs.h"

static __always_inline __u32 get_dc_net(const __u32 _addr[4])
{
    const volatile __u32 *addr = (const volatile __u32 *)_addr;
    __u32 a = addr[0];

    if (unlikely(a != YA_NETS))
        return 0;

    a = addr[1];

    __u32 key[2] = { 32, a };

    __u32 *net_dc = bpf_map_lookup_elem(&ya_nets_map, &key);
    return net_dc ? *net_dc : 0;
}

static __always_inline enum EDatacenter get_dc(const __u32 _addr[4])
{
    return (enum EDatacenter)((__u16)get_dc_net(_addr));
}

static __always_inline int get_sock_tc(struct bpf_sock_ops *skops)
{
    int tclass;
    if (bpf_getsockopt(skops, IPPROTO_IPV6, IPV6_TCLASS, &tclass, sizeof(tclass)) < 0)
        return 0;
    return tclass;
}

static __always_inline int set_sock_tc(struct bpf_sock_ops *skops, int tclass)
{
    return bpf_setsockopt(skops, IPPROTO_IPV6, IPV6_TCLASS, &tclass, sizeof(tclass));
}

static __always_inline int set_congestion_control(struct bpf_sock_ops *skops, char *cong)
{
    return bpf_setsockopt(skops, SOL_TCP, TCP_CONGESTION, cong, MAX_CONG_LEN);
}
