#pragma once

#define ECN_BIT  (unsigned char)2
#define ECN_MASK (unsigned char)3

#define NEXT_POW2(x) ((x) == 1 ? 1 : 1 << (64 - __builtin_clzl((x) - 1)))

#define MAX_CONG_LEN 16

enum EConfig {
    // kernel features
    CONF_JIFFIE_MS,

    // agent features
    CONF_MY_DC,
    CONF_CROSS_DC_RTO,
    CONF_SOCK_MIN_RTO,
    CONF_YTTL,
    CONF_TCP_BYTES_ACKED,
    CONF_TCP_BYTES_SENT,
    CONF_TCP_BYTES_RETRANS,
    CONF_TCP_BYTES_EXT_RETRANS,
    CONF_CONG_CONTROL,

    CONF__COUNT
};

enum ENetwork {
    NET_UNKNOWN = 0,
    NET_BACKBONE = 1,
    NET_FASTBONE = 2,

    NET__COUNT
};

#define NET__COUNT_POW2 NEXT_POW2(NET__COUNT)

enum EDatacenter {
    DC_UNKNOWN = 0,
    DC_SAS1 = 1,
    DC_SAS2 = 2,
    DC_VLA = 3,
    DC_VLX = 4,
    DC_MAN = 5,
    DC_IVA = 6,
    DC_MYT = 7,

    DC__COUNT
};

#define DC__COUNT_POW2 NEXT_POW2(DC__COUNT)

enum ETcpBytesCounterType {
    TCP_BYTES_ACKED = 0,
    TCP_BYTES_SENT = 1,
    TCP_BYTES_RETRANS = 2,
    TCP_BYTES_EXT_RETRANS = 3,

    TCP_BYTES__COUNT,
};

enum ETrafficClass {
    TC_CS0 = 0,
    TC_CS1 = 32,
    TC_CS2 = 64,
    TC_CS3 = 96,
    TC_CS4 = 128,
    TC_CS4_ECN = TC_CS4 + ECN_BIT,
};
