#include <linux/bpf.h>
#include <linux/version.h>

#include <bpf_helpers.h>

#include <map_defs/ya_nets.h>

#define NET_STAT_DC
#include <net_stat.h>

struct bpf_map_def SEC("maps") net_stat_dc_tx_map = {
    .type = BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE,
    .key_size = sizeof(struct bpf_cgroup_storage_key),
    .value_size = sizeof(struct cgroup_net_stat_dc),
};

SEC("cgroup_skb/egress")
int net_stat_dc_tx(struct __sk_buff *skb)
{
    return net_stat_dc(skb, &net_stat_dc_tx_map);
}

char _license[] SEC("license") = "GPL";
__u32 _version SEC("version") = LINUX_VERSION_CODE;
