#include <linux/bpf.h>
#include <linux/version.h>

#include <bpf_helpers.h>

#include <net_stat.h>

struct bpf_map_def SEC("maps") net_stat_rx_map = {
    .type = BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE,
    .key_size = sizeof(struct bpf_cgroup_storage_key),
    .value_size = sizeof(struct cgroup_net_stat),
};

SEC("cgroup_skb/ingress")
int net_stat_rx(struct __sk_buff *skb)
{
    return net_stat(skb, &net_stat_rx_map);
}

char _license[] SEC("license") = "GPL";
__u32 _version SEC("version") = LINUX_VERSION_CODE;
